/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.connection.impl;

import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionListener;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionManager;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionStatus;
import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2Handler;
import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2HandlerBuilder;
import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2Initializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManagerImpl.class);
    private boolean enableSsl;
    private Bootstrap bootstrap;
    private ChannelGroup channelGroup;
    private EventLoopGroup workerGroup;
    private final long heartbeatInterval;
    private final long heartbeatTimeoutThreshold;
    private List<ConnectionListener> connectionListeners;
    private ConnectionListener innerListener = new ConnectionListener(){

        @Override
        public void onSettingReceive(Connection connection, Http2Settings settings) {
            ConnectionManagerImpl.this.connectionListeners.forEach(l -> l.onSettingReceive(connection, settings));
        }

        @Override
        public void onStatusChange(ConnectionStatus status, Connection connection) {
            ConnectionManagerImpl.this.connectionListeners.forEach(l -> l.onStatusChange(status, connection));
        }
    };

    public ConnectionManagerImpl(boolean enableSsl, long heartBeatInterval, long heartbeatTimeoutThreshold) {
        this.enableSsl = enableSsl;
        this.heartbeatInterval = heartBeatInterval;
        this.heartbeatTimeoutThreshold = heartbeatTimeoutThreshold;
        this.connectionListeners = new ArrayList<ConnectionListener>();
        this.initNetty();
    }

    private void initNetty() {
        log.info("[ConnectionManagerImpl]initialize netty");
        NettyHttp2Initializer initializer = this.createNettyHttp2Initializer();
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.handler((ChannelHandler)initializer);
        this.channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    private NettyHttp2Initializer createNettyHttp2Initializer() {
        NettyHttp2HandlerBuilder http2HandlerBuilder = new NettyHttp2HandlerBuilder(this.heartbeatTimeoutThreshold);
        NettyHttp2Initializer initializer = null;
        try {
            initializer = new NettyHttp2Initializer(http2HandlerBuilder, this.enableSsl);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("failed to initialize netty, {}", (Throwable)e);
        }
        return initializer;
    }

    @Override
    public List<Connection> getConnectionList() {
        return this.channels().stream().map(this::getConnection).collect(Collectors.toList());
    }

    private Connection getConnection(Channel channel) {
        return ((NettyHttp2Handler)channel.pipeline().get(NettyHttp2Handler.class)).getConnection();
    }

    @Override
    public CompletableFuture<Connection> connect(SocketAddress address) {
        log.info("connecting to {}", (Object)address);
        CompletableFuture<Connection> cf = new CompletableFuture<Connection>();
        this.bootstrap.connect(address).addListeners(new GenericFutureListener[]{future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                this.channelGroup.add((Object)channel);
                channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)f -> this.getConnection(f.channel()).onConnectionClosed()));
                channel.pipeline().addFirst("heartBeatHandler", (ChannelHandler)new IdleStateHandler(this.heartbeatInterval, 0L, 0L, TimeUnit.MILLISECONDS));
                Connection connection = this.getConnection(channel);
                connection.setConnectionListener(this.innerListener);
                cf.complete(connection);
            } else {
                cf.completeExceptionally(future.cause());
            }
        }});
        return cf;
    }

    private List<Channel> channels() {
        return this.channelGroup.stream().filter(Channel::isOpen).filter(Channel::isActive).collect(Collectors.toList());
    }

    @Override
    public void shutdown() {
        this.channelGroup.close();
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }
}

