/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class TrafficCodeDistributionCollectionHandler
extends ChannelDuplexHandler {
    private final ConcurrentMap<Integer, AtomicLong> inboundDistribution = new ConcurrentHashMap<Integer, AtomicLong>();
    private final ConcurrentMap<Integer, AtomicLong> outboundDistribution = new ConcurrentHashMap<Integer, AtomicLong>();

    private void countInbound(int responseCode) {
        AtomicLong item = (AtomicLong)this.inboundDistribution.get(responseCode);
        if (null == item) {
            item = new AtomicLong(0L);
            AtomicLong previous = this.inboundDistribution.putIfAbsent(responseCode, item);
            if (null != previous) {
                item = previous;
            }
        }
        item.incrementAndGet();
    }

    private void countOutbound(int responseCode) {
        AtomicLong item = (AtomicLong)this.outboundDistribution.get(responseCode);
        if (null == item) {
            item = new AtomicLong(0L);
            AtomicLong previous = this.outboundDistribution.putIfAbsent(responseCode, item);
            if (null != previous) {
                item = previous;
            }
        }
        item.incrementAndGet();
    }

    public Map<Integer, Long> inboundDistribution() {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(this.inboundDistribution.size());
        for (Map.Entry entry : this.inboundDistribution.entrySet()) {
            map.put((Integer)entry.getKey(), ((AtomicLong)entry.getValue()).getAndSet(0L));
        }
        return map;
    }

    public Map<Integer, Long> outboundDistribution() {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(this.outboundDistribution.size());
        for (Map.Entry entry : this.outboundDistribution.entrySet()) {
            map.put((Integer)entry.getKey(), ((AtomicLong)entry.getValue()).getAndSet(0L));
        }
        return map;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof RemotingCommand) {
            RemotingCommand cmd = (RemotingCommand)msg;
            this.countInbound(cmd.getCode());
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof RemotingCommand) {
            RemotingCommand cmd = (RemotingCommand)msg;
            this.countOutbound(cmd.getCode());
        }
        ctx.write(msg, promise);
    }
}

