/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.stream;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.stream.BufferChainOutputStream;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.stream.Stream;
import com.aliyun.openservices.shade.com.google.common.base.Stopwatch;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class DefaultStream
implements Stream {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqRemoting");
    public static final int INITIAL_SLICE_SIZE = 65536;
    public static final int MAX_SLICE_SIZE = 0x100000;
    public static final int MAX_COMPONENT_NUMBER = 32;
    private final CompositeByteBuf bufferChain = PooledByteBufAllocator.DEFAULT.compositeDirectBuffer(32);

    protected void serialize() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LinkedList<ByteBuf> bufferChain = new LinkedList<ByteBuf>();
        BufferChainOutputStream outputStream = new BufferChainOutputStream(bufferChain, this.bufferChain.alloc());
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        JSON.writeJSONString((Writer)writer, (Object)this, SerializerFeature.BrowserCompatible, SerializerFeature.SkipTransientField, SerializerFeature.QuoteFieldNames);
        for (ByteBuf buffer : bufferChain) {
            this.bufferChain.addComponent(true, buffer);
        }
        LOGGER.debug("Serialization costs {}ms. Component number: {}", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), (Object)this.bufferChain.numComponents());
        LOGGER.debug("PooledCompositeBuffer: readerIndex={}, writerIndex={}, capacity={}", this.bufferChain.readerIndex(), this.bufferChain.writerIndex(), this.bufferChain.capacity());
    }

    @Override
    public int payloadLength() {
        return this.bufferChain.readableBytes();
    }

    @Override
    public ByteBuf payload() {
        return this.bufferChain.slice();
    }
}

