/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.utils.ResourceManager;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class OTSUtil {
    public static final ResourceManager OTS_RESOURCE_MANAGER = ResourceManager.getInstance("ots");

    public static byte[] dataEncode(String data) {
        try {
            return data.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Unsupported encoding\uff1autf-8");
        }
    }

    public static String dataDecode(byte[] bytes) {
        try {
            CharsetDecoder decoder = Charset.forName("utf-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT);
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(bytes));
            return cb.toString();
        }
        catch (CharacterCodingException e) {
            throw new ClientException(OTS_RESOURCE_MANAGER.getFormattedString("ValueInInvalidCharset", new String(bytes)));
        }
    }

    public static int stringtoUTF8Bytes(String str, byte[] buffer) {
        int index = 0;
        for (int i = 0; i < str.length(); ++i) {
            char strChar = str.charAt(i);
            if ((strChar & 0xFF80) == 0) {
                buffer[index++] = (byte)(strChar & 0xFF);
                continue;
            }
            if ((strChar & 0xF800) == 0) {
                buffer[index++] = (byte)(strChar >> 6 | 0xC0);
                buffer[index++] = (byte)(strChar & 0x3F | 0x80);
                continue;
            }
            buffer[index++] = (byte)(strChar >> 12 | 0xE0);
            buffer[index++] = (byte)(strChar >> 6 & 0x3F | 0x80);
            buffer[index++] = (byte)(strChar & 0x3F | 0x80);
        }
        return index;
    }

    public static int compare(PrimaryKeyValue left, PrimaryKeyValue right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.equals(PrimaryKeyValue.INF_MIN)) {
            return right.equals(PrimaryKeyValue.INF_MIN) ? 0 : -1;
        }
        if (left.equals(PrimaryKeyValue.INF_MAX)) {
            return right.equals(PrimaryKeyValue.INF_MAX) ? 0 : 1;
        }
        if (right.equals(PrimaryKeyValue.INF_MIN)) {
            return left.equals(PrimaryKeyValue.INF_MIN) ? 0 : 1;
        }
        if (right.equals(PrimaryKeyValue.INF_MAX)) {
            return left.equals(PrimaryKeyValue.INF_MAX) ? 0 : -1;
        }
        if (left.getType() == null || right.getType() == null || left.getType() != right.getType()) {
            throw new AssertionError((Object)"type mismatch.");
        }
        if (left.getType() == PrimaryKeyType.INTEGER) {
            long lRight;
            long lLeft = left.asLong();
            if (lLeft > (lRight = right.asLong())) {
                return 1;
            }
            if (lLeft < lRight) {
                return -1;
            }
            return 0;
        }
        if (left.getType() != PrimaryKeyType.STRING) {
            throw new AssertionError((Object)"type mismatch.");
        }
        return left.asString().compareTo(right.asString());
    }

    public static boolean isPKInf(PrimaryKeyValue pk) {
        return pk == PrimaryKeyValue.INF_MAX || pk == PrimaryKeyValue.INF_MIN;
    }
}

