/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteRowRequest {
    private Map<String, List<RowPutChange>> rowPutChangesGroupByTable = new HashMap<String, List<RowPutChange>>();
    private Map<String, List<RowUpdateChange>> rowUpdateChangesGroupByTable = new HashMap<String, List<RowUpdateChange>>();
    private Map<String, List<RowDeleteChange>> rowDeleteChangesGroupByTable = new HashMap<String, List<RowDeleteChange>>();

    public void addRowPutChange(RowPutChange rowPutChange) {
        CodingUtils.assertParameterNotNull(rowPutChange, "rowPutChange");
        String tableName = rowPutChange.getTableName();
        List<RowPutChange> rowPutChanges = this.rowPutChangesGroupByTable.get(tableName);
        if (rowPutChanges == null) {
            rowPutChanges = new ArrayList<RowPutChange>();
            this.rowPutChangesGroupByTable.put(tableName, rowPutChanges);
        }
        rowPutChanges.add(rowPutChange);
    }

    public RowPutChange getRowPutChange(String tableName, int index) {
        List<RowPutChange> rowPutChanges = this.rowPutChangesGroupByTable.get(tableName);
        if (rowPutChanges == null) {
            return null;
        }
        if (index >= rowPutChanges.size()) {
            return null;
        }
        return rowPutChanges.get(index);
    }

    public Map<String, List<RowPutChange>> getRowPutChange() {
        return this.rowPutChangesGroupByTable;
    }

    public void addRowChange(RowChange rowChange) {
        if (rowChange instanceof RowPutChange) {
            this.addRowPutChange((RowPutChange)rowChange);
        } else if (rowChange instanceof RowUpdateChange) {
            this.addRowUpdateChange((RowUpdateChange)rowChange);
        } else {
            this.addRowDeleteChange((RowDeleteChange)rowChange);
        }
    }

    public void addRowUpdateChange(RowUpdateChange rowUpdateChange) {
        CodingUtils.assertParameterNotNull(rowUpdateChange, "rowUpdateChange");
        String tableName = rowUpdateChange.getTableName();
        List<RowUpdateChange> rowUpdateChanges = this.rowUpdateChangesGroupByTable.get(tableName);
        if (rowUpdateChanges == null) {
            rowUpdateChanges = new ArrayList<RowUpdateChange>();
            this.rowUpdateChangesGroupByTable.put(tableName, rowUpdateChanges);
        }
        rowUpdateChanges.add(rowUpdateChange);
    }

    public RowUpdateChange getRowUpdateChange(String tableName, int index) {
        List<RowUpdateChange> rowUpdateChanges = this.rowUpdateChangesGroupByTable.get(tableName);
        if (rowUpdateChanges == null) {
            return null;
        }
        if (index >= rowUpdateChanges.size()) {
            return null;
        }
        return rowUpdateChanges.get(index);
    }

    public Map<String, List<RowUpdateChange>> getRowUpdateChange() {
        return this.rowUpdateChangesGroupByTable;
    }

    public void addRowDeleteChange(RowDeleteChange rowDeleteChange) {
        CodingUtils.assertParameterNotNull(rowDeleteChange, "rowDeleteChange");
        String tableName = rowDeleteChange.getTableName();
        List<RowDeleteChange> rowDeleteChanges = this.rowDeleteChangesGroupByTable.get(tableName);
        if (rowDeleteChanges == null) {
            rowDeleteChanges = new ArrayList<RowDeleteChange>();
            this.rowDeleteChangesGroupByTable.put(tableName, rowDeleteChanges);
        }
        rowDeleteChanges.add(rowDeleteChange);
    }

    public RowDeleteChange getRowDeleteChange(String tableName, int index) {
        List<RowDeleteChange> rowDeleteChanges = this.rowDeleteChangesGroupByTable.get(tableName);
        if (rowDeleteChanges == null) {
            return null;
        }
        if (index >= rowDeleteChanges.size()) {
            return null;
        }
        return rowDeleteChanges.get(index);
    }

    public Map<String, List<RowDeleteChange>> getRowDeleteChange() {
        return this.rowDeleteChangesGroupByTable;
    }

    public boolean isEmpty() {
        return this.rowPutChangesGroupByTable.isEmpty() && this.rowUpdateChangesGroupByTable.isEmpty() && this.rowDeleteChangesGroupByTable.isEmpty();
    }

    public int getRowsCount() {
        int rowsCount = 0;
        for (Map.Entry<String, List<RowPutChange>> entry : this.rowPutChangesGroupByTable.entrySet()) {
            rowsCount += entry.getValue().size();
        }
        for (Map.Entry<String, List<RowChange>> entry : this.rowUpdateChangesGroupByTable.entrySet()) {
            rowsCount += entry.getValue().size();
        }
        for (Map.Entry<String, List<RowChange>> entry : this.rowDeleteChangesGroupByTable.entrySet()) {
            rowsCount += entry.getValue().size();
        }
        return rowsCount;
    }

    public BatchWriteRowRequest createRequestForRetry(List<BatchWriteRowResult.RowStatus> failedRowsToPut, List<BatchWriteRowResult.RowStatus> failedRowsToUpdate, List<BatchWriteRowResult.RowStatus> failedRowsToDelete) {
        RowChange rowChange;
        BatchWriteRowRequest request = new BatchWriteRowRequest();
        if (failedRowsToPut != null) {
            for (BatchWriteRowResult.RowStatus rowResult : failedRowsToPut) {
                rowChange = this.getRowPutChange(rowResult.getTableName(), rowResult.getIndex());
                if (rowChange == null) {
                    throw new IllegalArgumentException("Can not find item in table '" + rowResult.getTableName() + "' " + "with index " + rowResult.getIndex());
                }
                request.addRowPutChange((RowPutChange)rowChange);
            }
        }
        if (failedRowsToUpdate != null) {
            for (BatchWriteRowResult.RowStatus rowResult : failedRowsToUpdate) {
                rowChange = this.getRowUpdateChange(rowResult.getTableName(), rowResult.getIndex());
                if (rowChange == null) {
                    throw new IllegalArgumentException("Can not find item in table '" + rowResult.getTableName() + "' " + "with index " + rowResult.getIndex());
                }
                request.addRowUpdateChange((RowUpdateChange)rowChange);
            }
        }
        if (failedRowsToDelete != null) {
            for (BatchWriteRowResult.RowStatus rowResult : failedRowsToDelete) {
                rowChange = this.getRowDeleteChange(rowResult.getTableName(), rowResult.getIndex());
                if (rowChange == null) {
                    throw new IllegalArgumentException("Can not find item in table '" + rowResult.getTableName() + "' " + "with index " + rowResult.getIndex());
                }
                request.addRowDeleteChange((RowDeleteChange)rowChange);
            }
        }
        return request;
    }
}

