/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class AsyncGetRowCompletion
extends AsyncCompletion<GetRowRequest, GetRowResponse> {
    GetRowRequest nextRequest;
    PrimaryKey primaryKey;
    List<Column> columns;
    CapacityUnit capacityUnit;
    List<String> requestIds;

    public AsyncGetRowCompletion(OperationLauncher<GetRowRequest, GetRowResponse> launcher, GetRowRequest request, TraceLogger tracer, ExecutorService callbackExecutor, RetryStrategy retry, ScheduledExecutorService retryExecutor) {
        super(launcher, request, tracer, callbackExecutor, retry, retryExecutor);
    }

    @Override
    public void completed(GetRowResponse result) {
        result.setTraceId(this.tracer.getTraceId());
        LogUtil.logOnCompleted(this.tracer, this.retry, result.getRequestId());
        this.tracer.printLog();
        if (!result.hasNextToken()) {
            if (this.nextRequest != null) {
                this.handleResult(result);
                this.onCompleted(this.request, this.buildFinalResult());
            } else {
                this.onCompleted(this.request, result);
            }
        } else {
            this.handleResult(result);
            this.sendNextRequest(result.getNextToken());
        }
    }

    void handleResult(GetRowResponse result) {
        if (result.getRow() != null) {
            if (this.primaryKey == null) {
                this.primaryKey = result.getRow().getPrimaryKey();
            }
            if (this.columns == null) {
                this.columns = new ArrayList<Column>();
            }
            this.columns.addAll(Arrays.asList(result.getRow().getColumns()));
        }
        if (this.capacityUnit == null) {
            this.capacityUnit = new CapacityUnit(0, 0);
        }
        if (this.requestIds == null) {
            this.requestIds = new ArrayList<String>();
        }
        this.capacityUnit.setReadCapacityUnit(this.capacityUnit.getReadCapacityUnit() + result.getConsumedCapacity().getCapacityUnit().getReadCapacityUnit());
        this.capacityUnit.setWriteCapacityUnit(this.capacityUnit.getWriteCapacityUnit() + result.getConsumedCapacity().getCapacityUnit().getWriteCapacityUnit());
        this.requestIds.add(result.getRequestId());
    }

    void buildNextRequest(byte[] token) {
        if (this.nextRequest == null) {
            SingleRowQueryCriteria singleRowQueryCriteria = new SingleRowQueryCriteria(((GetRowRequest)this.request).getRowQueryCriteria().getTableName(), ((GetRowRequest)this.request).getRowQueryCriteria().getPrimaryKey());
            ((GetRowRequest)this.request).getRowQueryCriteria().copyTo(singleRowQueryCriteria);
            this.nextRequest = new GetRowRequest(singleRowQueryCriteria);
        }
        this.nextRequest.getRowQueryCriteria().setToken(token);
    }

    void sendNextRequest(byte[] token) {
        this.buildNextRequest(token);
        this.retry = this.retry.clone();
        this.launcher.fire(this.nextRequest, this);
    }

    GetRowResponse buildFinalResult() {
        Row row = null;
        if (this.primaryKey != null) {
            row = new Row(this.primaryKey, this.columns);
        }
        return new GetRowResponse(new Response(this.requestIds.get(0)), row, new ConsumedCapacity(this.capacityUnit));
    }
}

