/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.core.protocol.TunnelServiceApi;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RecordColumn;
import com.alicloud.openservices.tablestore.model.RecordSequenceInfo;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.StreamRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PlainBufferConversion {
    public static Row toRow(PlainBufferRow plainBufferRow) throws IOException {
        return PlainBufferConversion.toRow(plainBufferRow, true);
    }

    public static Row toRow(PlainBufferRow plainBufferRow, boolean needSortColumns) throws IOException {
        if (plainBufferRow.hasDeleteMarker()) {
            throw new IOException("Row could not has delete marker: " + plainBufferRow);
        }
        if (plainBufferRow.getPrimaryKey() == null) {
            throw new IOException("Row has no primary key: " + plainBufferRow);
        }
        ArrayList<Column> columns = new ArrayList<Column>(plainBufferRow.getCells().size());
        for (PlainBufferCell cell : plainBufferRow.getCells()) {
            columns.add(PlainBufferConversion.toColumn(cell));
        }
        return new Row(PlainBufferConversion.toPrimaryKey(plainBufferRow.getPrimaryKey()), columns, needSortColumns);
    }

    public static Column toColumn(PlainBufferCell cell) throws IOException {
        if (!cell.hasCellName() || !cell.hasCellValue()) {
            throw new IOException("The cell has no name or value: " + cell);
        }
        if (cell.hasCellType() && cell.getCellType() != 4) {
            throw new IOException("The cell should not has type: " + cell);
        }
        if (cell.hasCellTimestamp()) {
            return new Column(cell.getCellName(), cell.getCellValue(), cell.getCellTimestamp());
        }
        return new Column(cell.getCellName(), cell.getCellValue());
    }

    public static RecordColumn toRecordColumn(PlainBufferCell cell) throws IOException {
        if (!cell.hasCellName()) {
            throw new IOException("The cell has no name:" + cell);
        }
        ColumnValue value = ColumnValue.INTERNAL_NULL_VALUE;
        if (cell.hasCellValue()) {
            value = cell.getCellValue();
        }
        Column column = null;
        column = cell.hasCellTimestamp() ? new Column(cell.getCellName(), value, cell.getCellTimestamp()) : new Column(cell.getCellName(), value);
        RecordColumn.ColumnType columnType = RecordColumn.ColumnType.PUT;
        if (!cell.hasCellType()) {
            if (!cell.hasCellValue() || !cell.hasCellTimestamp()) {
                throw new IOException("The cell should have both value and timestamp: " + cell);
            }
        } else {
            switch (cell.getCellType()) {
                case 3: {
                    if (cell.hasCellValue() || !cell.hasCellTimestamp()) {
                        throw new IOException("The cell with type DELETE_ONE_VERSION should not have value but should have timestamp: " + cell);
                    }
                    columnType = RecordColumn.ColumnType.DELETE_ONE_VERSION;
                    break;
                }
                case 1: {
                    if (cell.hasCellValue() || cell.hasCellTimestamp()) {
                        throw new IOException("The cell with type DELETE_ALL_VERSION should not have value and timestamp: " + cell);
                    }
                    columnType = RecordColumn.ColumnType.DELETE_ALL_VERSION;
                    break;
                }
                default: {
                    throw new IOException("Unknown cell type:" + cell.getCellType());
                }
            }
        }
        return new RecordColumn(column, columnType);
    }

    public static RecordColumn toTimeseriesRecordColumn(PlainBufferCell cell) throws IOException {
        RecordColumn recordColumn = PlainBufferConversion.toRecordColumn(cell);
        Column column = recordColumn.getColumn();
        Column timeseriesFormatColumn = column.hasSetTimestamp() ? new Column(column.getName().split(":")[0], column.getValue(), column.getTimestamp()) : new Column(column.getName().split(":")[0], column.getValue());
        recordColumn.setColumn(timeseriesFormatColumn);
        return recordColumn;
    }

    public static PrimaryKey toPrimaryKey(List<PlainBufferCell> pkCells) throws IOException {
        ArrayList<PrimaryKeyColumn> primaryKeyColumns = new ArrayList<PrimaryKeyColumn>();
        for (PlainBufferCell cell : pkCells) {
            primaryKeyColumns.add(new PrimaryKeyColumn(cell.getCellName(), PrimaryKeyValue.fromColumn(cell.getCellValue())));
        }
        return new PrimaryKey(primaryKeyColumns);
    }

    public static PrimaryKey toTimeseriesPrimaryKey(List<PlainBufferCell> pkCells) throws IOException {
        ArrayList<PrimaryKeyColumn> primaryKeyColumns = new ArrayList<PrimaryKeyColumn>();
        for (int i = 0; i < pkCells.size(); ++i) {
            if (i == 0 && !pkCells.get(i).getCellName().equals("_#h")) {
                throw new IOException("The expected primary key name is '_#h'. Actually : " + pkCells.get(i).getCellName() + ".");
            }
            if (i <= 0) continue;
            primaryKeyColumns.add(new PrimaryKeyColumn(pkCells.get(i).getCellName(), PrimaryKeyValue.fromColumn(pkCells.get(i).getCellValue())));
        }
        return new PrimaryKey(primaryKeyColumns);
    }

    public static PlainBufferCell toPlainBufferCell(PrimaryKeyColumn primaryKeyColumn) throws IOException {
        PlainBufferCell cell = new PlainBufferCell();
        cell.setCellName(primaryKeyColumn.getName());
        cell.setPkCellValue(primaryKeyColumn.getValue());
        return cell;
    }

    public static PlainBufferCell toPlainBufferCell(Column column, boolean ignoreValue, boolean ignoreTs, boolean setType, byte type) throws IOException {
        PlainBufferCell cell = new PlainBufferCell();
        cell.setCellName(column.getName());
        if (!ignoreValue) {
            cell.setCellValue(column.getValue());
        }
        if (!ignoreTs && column.hasSetTimestamp()) {
            cell.setCellTimestamp(column.getTimestamp());
        }
        if (setType) {
            cell.setCellType(type);
        }
        return cell;
    }

    public static StreamRecord toStreamRecord(PlainBufferRow pbRow, PlainBufferRow pbOriginRow, OtsInternalApi.ActionType actionType, boolean parseInTimeseriesDataFormat) throws IOException {
        ArrayList<RecordColumn> originColumns;
        ArrayList<RecordColumn> columns;
        StreamRecord record = new StreamRecord();
        switch (actionType) {
            case PUT_ROW: {
                record.setRecordType(StreamRecord.RecordType.PUT);
                break;
            }
            case UPDATE_ROW: {
                record.setRecordType(StreamRecord.RecordType.UPDATE);
                break;
            }
            case DELETE_ROW: {
                record.setRecordType(StreamRecord.RecordType.DELETE);
                break;
            }
            default: {
                throw new IOException("Unknown stream record action type:" + actionType.name());
            }
        }
        if (parseInTimeseriesDataFormat) {
            record.setPrimaryKey(PlainBufferConversion.toTimeseriesPrimaryKey(pbRow.getPrimaryKey()));
            columns = new ArrayList<RecordColumn>();
            for (PlainBufferCell plainBufferCell : pbRow.getCells()) {
                columns.add(PlainBufferConversion.toTimeseriesRecordColumn(plainBufferCell));
            }
            record.setColumns(columns);
            if (pbOriginRow != null) {
                originColumns = new ArrayList();
                for (PlainBufferCell cell : pbOriginRow.getCells()) {
                    originColumns.add(PlainBufferConversion.toTimeseriesRecordColumn(cell));
                }
                record.setOriginColumns(originColumns);
            }
        } else {
            record.setPrimaryKey(PlainBufferConversion.toPrimaryKey(pbRow.getPrimaryKey()));
            columns = new ArrayList();
            for (PlainBufferCell plainBufferCell : pbRow.getCells()) {
                columns.add(PlainBufferConversion.toRecordColumn(plainBufferCell));
            }
            record.setColumns(columns);
            if (pbOriginRow != null) {
                originColumns = new ArrayList<RecordColumn>();
                for (PlainBufferCell cell : pbOriginRow.getCells()) {
                    originColumns.add(PlainBufferConversion.toRecordColumn(cell));
                }
                record.setOriginColumns(originColumns);
            }
        }
        int epoch = pbRow.getExtension().getSequenceInfo().getEpoch();
        long ts = pbRow.getExtension().getSequenceInfo().getTimestamp();
        int rowIndex = pbRow.getExtension().getSequenceInfo().getRowIndex();
        RecordSequenceInfo seq = new RecordSequenceInfo(epoch, ts, rowIndex);
        record.setSequenceInfo(seq);
        return record;
    }

    public static StreamRecord toStreamRecord(PlainBufferRow pbRow, PlainBufferRow pbOriginRow, TunnelServiceApi.ActionType actionType, boolean parseInTimeseriesDataFormat) throws IOException {
        OtsInternalApi.ActionType atype;
        switch (actionType) {
            case PUT_ROW: {
                atype = OtsInternalApi.ActionType.PUT_ROW;
                break;
            }
            case UPDATE_ROW: {
                atype = OtsInternalApi.ActionType.UPDATE_ROW;
                break;
            }
            case DELETE_ROW: {
                atype = OtsInternalApi.ActionType.DELETE_ROW;
                break;
            }
            default: {
                throw new IOException("Unknown stream record action type:" + actionType.name());
            }
        }
        return PlainBufferConversion.toStreamRecord(pbRow, pbOriginRow, atype, parseInTimeseriesDataFormat);
    }
}

