/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRowResponse
extends Response
implements Jsonizable {
    private Map<String, List<RowResult>> tableToRowsResult = new HashMap<String, List<RowResult>>();

    public BatchGetRowResponse(Response meta) {
        super(meta);
    }

    public void addResult(RowResult result) {
        String tableName = result.getTableName();
        List<RowResult> tableRowResult = this.tableToRowsResult.get(tableName);
        if (tableRowResult == null) {
            tableRowResult = new ArrayList<RowResult>();
            this.tableToRowsResult.put(tableName, tableRowResult);
        }
        tableRowResult.add(result);
    }

    public List<RowResult> getBatchGetRowResult(String tableName) {
        return this.tableToRowsResult.get(tableName);
    }

    public Map<String, List<RowResult>> getTableToRowsResult() {
        return this.tableToRowsResult;
    }

    public List<RowResult> getFailedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(null, result);
        return result;
    }

    public List<RowResult> getSucceedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(result, null);
        return result;
    }

    public void getResult(List<RowResult> succeedRows, List<RowResult> failedRows) {
        for (Map.Entry<String, List<RowResult>> entry : this.tableToRowsResult.entrySet()) {
            for (RowResult rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public boolean isAllSucceed() {
        return this.getFailedRows().isEmpty();
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        for (Map.Entry<String, List<RowResult>> tableResult : this.tableToRowsResult.entrySet()) {
            for (RowResult result : tableResult.getValue()) {
                sb.append("{\"TableName\": ");
                sb.append(result.getTableName() + ", \"ConsumedCapacity\": ");
                result.getConsumedCapacity().jsonize(sb, newline + "  ");
                if (result.getRow() == null) continue;
                sb.append(", \"Row\": " + result.getRow().toString());
            }
        }
        sb.append("}");
    }

    public static class RowResult {
        private boolean isSucceed = false;
        private String tableName;
        private Error error;
        private Row row;
        private ConsumedCapacity consumedCapacity;
        private int index;
        private byte[] nextToken;

        public RowResult(String tableName, Error error, int index) {
            this.isSucceed = false;
            this.tableName = tableName;
            this.error = error;
            this.index = index;
        }

        public RowResult(String tableName, Row row, ConsumedCapacity consumedCapacity, int index) {
            this(tableName, row, consumedCapacity, index, null);
        }

        public RowResult(String tableName, Row row, ConsumedCapacity consumedCapacity, int index, byte[] nextToken) {
            this.isSucceed = true;
            this.tableName = tableName;
            this.row = row;
            this.consumedCapacity = consumedCapacity;
            this.index = index;
            this.nextToken = nextToken;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Error getError() {
            return this.error;
        }

        public Row getRow() {
            return this.row;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public int getIndex() {
            return this.index;
        }

        public byte[] getNextToken() {
            return this.nextToken;
        }

        public boolean hasNextToken() {
            return this.nextToken != null && this.nextToken.length > 0;
        }
    }
}

