/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.RowChange;
import java.util.ArrayList;
import java.util.List;

public class BulkImportRequest
implements Request {
    private String tableName;
    private List<RowChange> rowChanges = new ArrayList<RowChange>();

    public BulkImportRequest(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getOperationName() {
        return "BulkImport";
    }

    public void addRowChange(RowChange rowChange) {
        Preconditions.checkNotNull(rowChange, "The rowPutChange should not be null.");
        this.rowChanges.add(rowChange);
    }

    public void addRowChanges(List<RowChange> rowChanges) {
        Preconditions.checkNotNull(rowChanges, "The rowPutChanges should not be null.");
        for (RowChange rowChange : rowChanges) {
            Preconditions.checkNotNull(rowChange, String.format("The rowPutChange should not be null.", new Object[0]));
            this.rowChanges.add(rowChange);
        }
    }

    public List<RowChange> getRowChange() {
        return this.rowChanges;
    }

    public RowChange getRowChange(int index) {
        return this.rowChanges.get(index);
    }

    public BulkImportRequest createRequestForRetry(List<BulkImportResponse.RowResult> failedRows) {
        Preconditions.checkArgument(failedRows != null && !failedRows.isEmpty(), "failedRows can't be null or empty.");
        BulkImportRequest request = new BulkImportRequest(this.tableName);
        for (BulkImportResponse.RowResult rowResult : failedRows) {
            RowChange rowChange = this.getRowChange(rowResult.getIndex());
            if (rowChange == null) {
                throw new IllegalArgumentException("Can not find item in table '" + this.tableName + "' with index " + rowResult.getIndex());
            }
            request.addRowChange(rowChange);
        }
        return request;
    }

    public boolean isEmpty() {
        return this.rowChanges.isEmpty();
    }

    public int getRowsCount() {
        return this.rowChanges.size();
    }
}

