/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;

public class PrimaryKeySchema
implements Jsonizable {
    private String name;
    private PrimaryKeyType type;
    private PrimaryKeyOption option;

    public PrimaryKeySchema(String name, PrimaryKeyType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Primary key's name should not be null or empty.");
        Preconditions.checkNotNull(type, "The type should not be null");
        this.setName(name);
        this.setType(type);
        this.setOption(null);
    }

    public PrimaryKeySchema(String name, PrimaryKeyType type, PrimaryKeyOption option) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Primary key's name should not be null or empty.");
        Preconditions.checkNotNull(type, "The type should not be null.");
        Preconditions.checkNotNull(option, "The option should not be null.");
        Preconditions.checkArgument(option != PrimaryKeyOption.AUTO_INCREMENT || type == PrimaryKeyType.INTEGER, "Auto_Increment PK must be Integer type.");
        this.setName(name);
        this.setType(type);
        this.setOption(option);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrimaryKeyType getType() {
        return this.type;
    }

    public void setType(PrimaryKeyType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeySchema)) {
            return false;
        }
        PrimaryKeySchema target = (PrimaryKeySchema)o;
        return this.name.equals(target.name) && this.type == target.type && this.option == target.option;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode() ^ (this.hasOption() ? this.option.hashCode() : 0);
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.type) + (this.hasOption() ? ":" + (Object)((Object)this.option) : "");
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        if (this.hasOption()) {
            sb.append(String.format("{\"Name\": \"%s\", \"Type\": \"%s\", \"Option\":\"%s\"}", this.name, this.type.toString(), this.option.toString()));
        } else {
            sb.append(String.format("{\"Name\": \"%s\", \"Type\": \"%s\"}", this.name, this.type.toString()));
        }
    }

    public boolean hasOption() {
        return this.option != null;
    }

    public PrimaryKeyOption getOption() {
        return this.option;
    }

    public void setOption(PrimaryKeyOption option) {
        this.option = option;
    }
}

