/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.AbstractColumnIteratorImpl;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.WideRowIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RowRangeColumnIteratorImpl
extends AbstractColumnIteratorImpl {
    private WideRowIterator wideRowIterator;
    private PrimaryKey primaryKey;
    private Iterator<Column> columnIterator;
    private boolean complete = false;
    private boolean close = false;

    public RowRangeColumnIteratorImpl(WideRowIterator wideRowIterator, PrimaryKey primaryKey, Iterator<Column> columnIterator, boolean complete) {
        this.wideRowIterator = wideRowIterator;
        this.primaryKey = primaryKey;
        this.columnIterator = columnIterator;
        this.complete = complete;
    }

    private boolean doHasNext() {
        while (!this.complete && !this.columnIterator.hasNext()) {
            this.wideRowIterator.fetchData();
        }
        return this.columnIterator.hasNext();
    }

    private Column doNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.columnIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.close) {
            throw new ClientException("The iterator has been closed.");
        }
        return this.doHasNext();
    }

    @Override
    public Column next() {
        if (this.close) {
            throw new ClientException("The iterator has been closed.");
        }
        return this.doNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setColumnIterator(Iterator<Column> columnIterator) {
        this.columnIterator = columnIterator;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void close() {
        this.close = true;
        while (this.doHasNext()) {
            this.doNext();
        }
    }
}

