/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.RequestTracer;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ExecutionContext;
import com.alicloud.openservices.tablestore.core.http.HttpFactory;
import com.alicloud.openservices.tablestore.core.http.RequestHandler;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import com.alicloud.openservices.tablestore.core.http.ResponseConsumer;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

public class AsyncServiceClient {
    private CloseableHttpAsyncClient httpClient;
    private IdleConnectionEvictor connEvictor;
    private Map<String, String> extraHeaders;

    public AsyncServiceClient(ClientConfiguration config) {
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            cm.setMaxTotal(config.getMaxConnections());
            cm.setDefaultMaxPerRoute(config.getMaxConnections());
            this.httpClient = HttpFactory.createHttpAsyncClient(config, cm);
            long closePeriod = 5000L;
            if (config.getSocketTimeoutInMillisecond() > 0) {
                closePeriod = (long)((double)config.getSocketTimeoutInMillisecond() / 2.5);
            }
            closePeriod = closePeriod < 5000L ? closePeriod : 5000L;
            this.connEvictor = new IdleConnectionEvictor((NHttpClientConnectionManager)cm, closePeriod);
            this.httpClient.start();
            this.connEvictor.start();
        }
        catch (IOReactorException ex) {
            throw new ClientException(String.format("IOReactorError: %s", ex.getMessage()), ex);
        }
    }

    public Map<String, String> getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public <Res> void asyncSendRequest(RequestMessage request, ExecutionContext context, ResponseConsumer<Res> consumer, FutureCallback<Res> callback, TraceLogger traceLogger, RequestTracer requestTracer, Object rpcContext) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(context);
        this.addExtraHeaders(request);
        context.getSigner().sign(request);
        this.handleRequest(request, context.getResquestHandlers());
        consumer.setContext(context);
        HttpHost target = request.getActionUri().getHost();
        if (LogUtil.LOG.isDebugEnabled()) {
            LogUtil.LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "IntoHttpAsyncClient");
        }
        traceLogger.addEventTime("IntoHttpAsyncClient", System.currentTimeMillis());
        this.httpClient.execute((HttpAsyncRequestProducer)new OTSRequestProducer(target, request, traceLogger, requestTracer, rpcContext), consumer, callback);
    }

    private void addExtraHeaders(RequestMessage request) {
        if (this.extraHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.extraHeaders.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void handleRequest(RequestMessage message, List<RequestHandler> requestHandlers) throws ClientException {
        for (RequestHandler h : requestHandlers) {
            h.handle(message);
        }
    }

    public void shutdown() {
        try {
            this.connEvictor.shutdown();
            this.connEvictor.join();
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new ClientException("Failed to shutdown http client.", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class OTSRequestProducer
    extends BasicAsyncRequestProducer {
        private TraceLogger traceLogger;
        private RequestMessage requestMessage;
        private Object rpcContext;
        private RequestTracer requestTracer;

        public OTSRequestProducer(HttpHost target, RequestMessage request, TraceLogger traceLogger, RequestTracer requestTracer, Object rpcContext) {
            super(target, (HttpRequest)request.getRequest());
            this.traceLogger = traceLogger;
            this.requestMessage = request;
            this.requestTracer = requestTracer;
            this.rpcContext = rpcContext;
        }

        public void requestCompleted(HttpContext context) {
            super.requestCompleted(context);
            if (LogUtil.LOG.isDebugEnabled()) {
                LogUtil.LOG.debug("TraceId:" + this.traceLogger.getTraceId() + "\t" + "RequestSent");
            }
            if (this.requestTracer != null) {
                RequestTracer.RequestSendTraceInfo requestSendTraceInfo = new RequestTracer.RequestSendTraceInfo(this.requestMessage.getContentLength(), this.requestMessage.getActionUri().getHost().getHostName(), this.rpcContext);
                this.requestTracer.requestSend(requestSendTraceInfo);
            }
            this.traceLogger.addEventTime("RequestSent", System.currentTimeMillis());
        }
    }

    static class IdleConnectionEvictor
    extends Thread {
        private final NHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;
        private long closePeriod;

        public IdleConnectionEvictor(NHttpClientConnectionManager connMgr, long closePeriod) {
            this.connMgr = connMgr;
            this.closePeriod = closePeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionEvictor idleConnectionEvictor = this;
                    synchronized (idleConnectionEvictor) {
                        this.wait(this.closePeriod);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(this.closePeriod, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionEvictor idleConnectionEvictor = this;
            synchronized (idleConnectionEvictor) {
                this.notifyAll();
            }
        }
    }
}

