/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream;

import com.alicloud.openservices.tablestore.ClientException;
import java.util.concurrent.TimeUnit;

public class TimestreamDBConfiguration {
    private String metaTableName;
    private boolean dumpMeta = true;
    private long intervalDumpMeta = 600L;
    private long metaCacheSize = 0xA00000L;
    private int threadNumForWriter = 4;
    private int maxDataTableNumForWrite = 63;

    public TimestreamDBConfiguration(String metaTableName) {
        this.setMetaTableName(metaTableName);
    }

    private void setMetaTableName(String metaTableName) {
        if (metaTableName == null || metaTableName.isEmpty()) {
            throw new ClientException("Meta table name cannot be empty");
        }
        this.metaTableName = metaTableName;
    }

    public String getMetaTableName() {
        return this.metaTableName;
    }

    public int getMaxDataTableNumForWrite() {
        return this.maxDataTableNumForWrite;
    }

    public void setMaxDataTableNumForWrite(int maxDataTableNumForWrite) {
        this.maxDataTableNumForWrite = maxDataTableNumForWrite;
    }

    public void setDumpMeta(boolean dumpMeta) {
        this.dumpMeta = dumpMeta;
    }

    public boolean getDumpMeta() {
        return this.dumpMeta;
    }

    public void setIntervalDumpMeta(int interval, TimeUnit unit) {
        this.intervalDumpMeta = unit.toSeconds(interval);
    }

    public long getIntervalDumpMeta(TimeUnit unit) {
        return unit.convert(this.intervalDumpMeta, TimeUnit.SECONDS);
    }

    public void setMetaCacheSize(long metaCacheSize) {
        this.metaCacheSize = metaCacheSize;
    }

    public long getMetaCacheSize() {
        return this.metaCacheSize;
    }

    public void setThreadNumForWriter(int threadNumForWriter) {
        this.threadNumForWriter = threadNumForWriter;
    }

    public int getThreadNumForWriter() {
        return this.threadNumForWriter;
    }
}

