/*
 * Copyright 2010-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.sns.model;

import java.io.Serializable;

public class GetSMSSandboxAccountStatusResult implements Serializable {
    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS
     * sandbox.
     * </p>
     */
    private Boolean isInSandbox;

    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS
     * sandbox.
     * </p>
     *
     * @return <p>
     *         Indicates whether the calling Amazon Web Services account is in
     *         the SMS sandbox.
     *         </p>
     */
    public Boolean isIsInSandbox() {
        return isInSandbox;
    }

    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS
     * sandbox.
     * </p>
     *
     * @return <p>
     *         Indicates whether the calling Amazon Web Services account is in
     *         the SMS sandbox.
     *         </p>
     */
    public Boolean getIsInSandbox() {
        return isInSandbox;
    }

    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS
     * sandbox.
     * </p>
     *
     * @param isInSandbox <p>
     *            Indicates whether the calling Amazon Web Services account is
     *            in the SMS sandbox.
     *            </p>
     */
    public void setIsInSandbox(Boolean isInSandbox) {
        this.isInSandbox = isInSandbox;
    }

    /**
     * <p>
     * Indicates whether the calling Amazon Web Services account is in the SMS
     * sandbox.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param isInSandbox <p>
     *            Indicates whether the calling Amazon Web Services account is
     *            in the SMS sandbox.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public GetSMSSandboxAccountStatusResult withIsInSandbox(Boolean isInSandbox) {
        this.isInSandbox = isInSandbox;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIsInSandbox() != null)
            sb.append("IsInSandbox: " + getIsInSandbox());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getIsInSandbox() == null) ? 0 : getIsInSandbox().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetSMSSandboxAccountStatusResult == false)
            return false;
        GetSMSSandboxAccountStatusResult other = (GetSMSSandboxAccountStatusResult) obj;

        if (other.getIsInSandbox() == null ^ this.getIsInSandbox() == null)
            return false;
        if (other.getIsInSandbox() != null
                && other.getIsInSandbox().equals(this.getIsInSandbox()) == false)
            return false;
        return true;
    }
}
