/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appregistry.model.ApplicationTagStatus;
import com.amazonaws.services.appregistry.model.ResourcesListItem;
import com.amazonaws.services.appregistry.model.transform.ApplicationTagResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationTagResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationTagStatus;
    private String errorMessage;
    private List<ResourcesListItem> resources;
    private String nextToken;

    public void setApplicationTagStatus(String applicationTagStatus) {
        this.applicationTagStatus = applicationTagStatus;
    }

    public String getApplicationTagStatus() {
        return this.applicationTagStatus;
    }

    public ApplicationTagResult withApplicationTagStatus(String applicationTagStatus) {
        this.setApplicationTagStatus(applicationTagStatus);
        return this;
    }

    public ApplicationTagResult withApplicationTagStatus(ApplicationTagStatus applicationTagStatus) {
        this.applicationTagStatus = applicationTagStatus.toString();
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ApplicationTagResult withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public List<ResourcesListItem> getResources() {
        return this.resources;
    }

    public void setResources(Collection<ResourcesListItem> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<ResourcesListItem>(resources);
    }

    public ApplicationTagResult withResources(ResourcesListItem ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<ResourcesListItem>(resources.length));
        }
        for (ResourcesListItem ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public ApplicationTagResult withResources(Collection<ResourcesListItem> resources) {
        this.setResources(resources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ApplicationTagResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationTagStatus() != null) {
            sb.append("ApplicationTagStatus: ").append(this.getApplicationTagStatus()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationTagResult)) {
            return false;
        }
        ApplicationTagResult other = (ApplicationTagResult)obj;
        if (other.getApplicationTagStatus() == null ^ this.getApplicationTagStatus() == null) {
            return false;
        }
        if (other.getApplicationTagStatus() != null && !other.getApplicationTagStatus().equals(this.getApplicationTagStatus())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationTagStatus() == null ? 0 : this.getApplicationTagStatus().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ApplicationTagResult clone() {
        try {
            return (ApplicationTagResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationTagResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

