/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appregistry.model.AssociationOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssociateResourceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String applicationArn;
    private String resourceArn;
    private List<String> options;

    public void setApplicationArn(String applicationArn) {
        this.applicationArn = applicationArn;
    }

    public String getApplicationArn() {
        return this.applicationArn;
    }

    public AssociateResourceResult withApplicationArn(String applicationArn) {
        this.setApplicationArn(applicationArn);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public AssociateResourceResult withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<String> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<String>(options);
    }

    public AssociateResourceResult withOptions(String ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<String>(options.length));
        }
        for (String ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public AssociateResourceResult withOptions(Collection<String> options) {
        this.setOptions(options);
        return this;
    }

    public AssociateResourceResult withOptions(AssociationOption ... options) {
        ArrayList<String> optionsCopy = new ArrayList<String>(options.length);
        for (AssociationOption value : options) {
            optionsCopy.add(value.toString());
        }
        if (this.getOptions() == null) {
            this.setOptions(optionsCopy);
        } else {
            this.getOptions().addAll(optionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationArn() != null) {
            sb.append("ApplicationArn: ").append(this.getApplicationArn()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceResult)) {
            return false;
        }
        AssociateResourceResult other = (AssociateResourceResult)obj;
        if (other.getApplicationArn() == null ^ this.getApplicationArn() == null) {
            return false;
        }
        if (other.getApplicationArn() != null && !other.getApplicationArn().equals(this.getApplicationArn())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationArn() == null ? 0 : this.getApplicationArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public AssociateResourceResult clone() {
        try {
            return (AssociateResourceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

