/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.CodeConfiguration;
import com.amazonaws.services.apprunner.model.SourceCodeVersion;
import com.amazonaws.services.apprunner.model.transform.CodeRepositoryMarshaller;
import java.io.Serializable;

public class CodeRepository
implements Serializable,
Cloneable,
StructuredPojo {
    private String repositoryUrl;
    private SourceCodeVersion sourceCodeVersion;
    private CodeConfiguration codeConfiguration;
    private String sourceDirectory;

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public CodeRepository withRepositoryUrl(String repositoryUrl) {
        this.setRepositoryUrl(repositoryUrl);
        return this;
    }

    public void setSourceCodeVersion(SourceCodeVersion sourceCodeVersion) {
        this.sourceCodeVersion = sourceCodeVersion;
    }

    public SourceCodeVersion getSourceCodeVersion() {
        return this.sourceCodeVersion;
    }

    public CodeRepository withSourceCodeVersion(SourceCodeVersion sourceCodeVersion) {
        this.setSourceCodeVersion(sourceCodeVersion);
        return this;
    }

    public void setCodeConfiguration(CodeConfiguration codeConfiguration) {
        this.codeConfiguration = codeConfiguration;
    }

    public CodeConfiguration getCodeConfiguration() {
        return this.codeConfiguration;
    }

    public CodeRepository withCodeConfiguration(CodeConfiguration codeConfiguration) {
        this.setCodeConfiguration(codeConfiguration);
        return this;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public CodeRepository withSourceDirectory(String sourceDirectory) {
        this.setSourceDirectory(sourceDirectory);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryUrl() != null) {
            sb.append("RepositoryUrl: ").append(this.getRepositoryUrl()).append(",");
        }
        if (this.getSourceCodeVersion() != null) {
            sb.append("SourceCodeVersion: ").append(this.getSourceCodeVersion()).append(",");
        }
        if (this.getCodeConfiguration() != null) {
            sb.append("CodeConfiguration: ").append(this.getCodeConfiguration()).append(",");
        }
        if (this.getSourceDirectory() != null) {
            sb.append("SourceDirectory: ").append(this.getSourceDirectory());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepository)) {
            return false;
        }
        CodeRepository other = (CodeRepository)obj;
        if (other.getRepositoryUrl() == null ^ this.getRepositoryUrl() == null) {
            return false;
        }
        if (other.getRepositoryUrl() != null && !other.getRepositoryUrl().equals(this.getRepositoryUrl())) {
            return false;
        }
        if (other.getSourceCodeVersion() == null ^ this.getSourceCodeVersion() == null) {
            return false;
        }
        if (other.getSourceCodeVersion() != null && !other.getSourceCodeVersion().equals(this.getSourceCodeVersion())) {
            return false;
        }
        if (other.getCodeConfiguration() == null ^ this.getCodeConfiguration() == null) {
            return false;
        }
        if (other.getCodeConfiguration() != null && !other.getCodeConfiguration().equals(this.getCodeConfiguration())) {
            return false;
        }
        if (other.getSourceDirectory() == null ^ this.getSourceDirectory() == null) {
            return false;
        }
        return other.getSourceDirectory() == null || other.getSourceDirectory().equals(this.getSourceDirectory());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryUrl() == null ? 0 : this.getRepositoryUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSourceCodeVersion() == null ? 0 : this.getSourceCodeVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCodeConfiguration() == null ? 0 : this.getCodeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDirectory() == null ? 0 : this.getSourceDirectory().hashCode());
        return hashCode;
    }

    public CodeRepository clone() {
        try {
            return (CodeRepository)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeRepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

