/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apptest.model.ResourceType;

@SdkInternalApi
public class ResourceTypeMarshaller {
    private static final MarshallingInfo<StructuredPojo> CLOUDFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudFormation").build();
    private static final MarshallingInfo<StructuredPojo> M2MANAGEDAPPLICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m2ManagedApplication").build();
    private static final MarshallingInfo<StructuredPojo> M2NONMANAGEDAPPLICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m2NonManagedApplication").build();
    private static final ResourceTypeMarshaller instance = new ResourceTypeMarshaller();

    public static ResourceTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceType resourceType, ProtocolMarshaller protocolMarshaller) {
        if (resourceType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceType.getCloudFormation(), CLOUDFORMATION_BINDING);
            protocolMarshaller.marshall((Object)resourceType.getM2ManagedApplication(), M2MANAGEDAPPLICATION_BINDING);
            protocolMarshaller.marshall((Object)resourceType.getM2NonManagedApplication(), M2NONMANAGEDAPPLICATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

