/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apptest.model.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTestCaseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String testCaseId;
    private String description;
    private List<Step> steps;

    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public UpdateTestCaseRequest withTestCaseId(String testCaseId) {
        this.setTestCaseId(testCaseId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateTestCaseRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<Step> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<Step>(steps);
    }

    public UpdateTestCaseRequest withSteps(Step ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<Step>(steps.length));
        }
        for (Step ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public UpdateTestCaseRequest withSteps(Collection<Step> steps) {
        this.setSteps(steps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTestCaseId() != null) {
            sb.append("TestCaseId: ").append(this.getTestCaseId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestCaseRequest)) {
            return false;
        }
        UpdateTestCaseRequest other = (UpdateTestCaseRequest)obj;
        if (other.getTestCaseId() == null ^ this.getTestCaseId() == null) {
            return false;
        }
        if (other.getTestCaseId() != null && !other.getTestCaseId().equals(this.getTestCaseId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTestCaseId() == null ? 0 : this.getTestCaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    public UpdateTestCaseRequest clone() {
        return (UpdateTestCaseRequest)super.clone();
    }
}

