/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.FoundationModelLifecycle;
import com.amazonaws.services.bedrock.model.InferenceType;
import com.amazonaws.services.bedrock.model.ModelCustomization;
import com.amazonaws.services.bedrock.model.ModelModality;
import com.amazonaws.services.bedrock.model.transform.FoundationModelSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FoundationModelSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String modelArn;
    private String modelId;
    private String modelName;
    private String providerName;
    private List<String> inputModalities;
    private List<String> outputModalities;
    private Boolean responseStreamingSupported;
    private List<String> customizationsSupported;
    private List<String> inferenceTypesSupported;
    private FoundationModelLifecycle modelLifecycle;

    public void setModelArn(String modelArn) {
        this.modelArn = modelArn;
    }

    public String getModelArn() {
        return this.modelArn;
    }

    public FoundationModelSummary withModelArn(String modelArn) {
        this.setModelArn(modelArn);
        return this;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public FoundationModelSummary withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public FoundationModelSummary withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public FoundationModelSummary withProviderName(String providerName) {
        this.setProviderName(providerName);
        return this;
    }

    public List<String> getInputModalities() {
        return this.inputModalities;
    }

    public void setInputModalities(Collection<String> inputModalities) {
        if (inputModalities == null) {
            this.inputModalities = null;
            return;
        }
        this.inputModalities = new ArrayList<String>(inputModalities);
    }

    public FoundationModelSummary withInputModalities(String ... inputModalities) {
        if (this.inputModalities == null) {
            this.setInputModalities(new ArrayList<String>(inputModalities.length));
        }
        for (String ele : inputModalities) {
            this.inputModalities.add(ele);
        }
        return this;
    }

    public FoundationModelSummary withInputModalities(Collection<String> inputModalities) {
        this.setInputModalities(inputModalities);
        return this;
    }

    public FoundationModelSummary withInputModalities(ModelModality ... inputModalities) {
        ArrayList<String> inputModalitiesCopy = new ArrayList<String>(inputModalities.length);
        for (ModelModality value : inputModalities) {
            inputModalitiesCopy.add(value.toString());
        }
        if (this.getInputModalities() == null) {
            this.setInputModalities(inputModalitiesCopy);
        } else {
            this.getInputModalities().addAll(inputModalitiesCopy);
        }
        return this;
    }

    public List<String> getOutputModalities() {
        return this.outputModalities;
    }

    public void setOutputModalities(Collection<String> outputModalities) {
        if (outputModalities == null) {
            this.outputModalities = null;
            return;
        }
        this.outputModalities = new ArrayList<String>(outputModalities);
    }

    public FoundationModelSummary withOutputModalities(String ... outputModalities) {
        if (this.outputModalities == null) {
            this.setOutputModalities(new ArrayList<String>(outputModalities.length));
        }
        for (String ele : outputModalities) {
            this.outputModalities.add(ele);
        }
        return this;
    }

    public FoundationModelSummary withOutputModalities(Collection<String> outputModalities) {
        this.setOutputModalities(outputModalities);
        return this;
    }

    public FoundationModelSummary withOutputModalities(ModelModality ... outputModalities) {
        ArrayList<String> outputModalitiesCopy = new ArrayList<String>(outputModalities.length);
        for (ModelModality value : outputModalities) {
            outputModalitiesCopy.add(value.toString());
        }
        if (this.getOutputModalities() == null) {
            this.setOutputModalities(outputModalitiesCopy);
        } else {
            this.getOutputModalities().addAll(outputModalitiesCopy);
        }
        return this;
    }

    public void setResponseStreamingSupported(Boolean responseStreamingSupported) {
        this.responseStreamingSupported = responseStreamingSupported;
    }

    public Boolean getResponseStreamingSupported() {
        return this.responseStreamingSupported;
    }

    public FoundationModelSummary withResponseStreamingSupported(Boolean responseStreamingSupported) {
        this.setResponseStreamingSupported(responseStreamingSupported);
        return this;
    }

    public Boolean isResponseStreamingSupported() {
        return this.responseStreamingSupported;
    }

    public List<String> getCustomizationsSupported() {
        return this.customizationsSupported;
    }

    public void setCustomizationsSupported(Collection<String> customizationsSupported) {
        if (customizationsSupported == null) {
            this.customizationsSupported = null;
            return;
        }
        this.customizationsSupported = new ArrayList<String>(customizationsSupported);
    }

    public FoundationModelSummary withCustomizationsSupported(String ... customizationsSupported) {
        if (this.customizationsSupported == null) {
            this.setCustomizationsSupported(new ArrayList<String>(customizationsSupported.length));
        }
        for (String ele : customizationsSupported) {
            this.customizationsSupported.add(ele);
        }
        return this;
    }

    public FoundationModelSummary withCustomizationsSupported(Collection<String> customizationsSupported) {
        this.setCustomizationsSupported(customizationsSupported);
        return this;
    }

    public FoundationModelSummary withCustomizationsSupported(ModelCustomization ... customizationsSupported) {
        ArrayList<String> customizationsSupportedCopy = new ArrayList<String>(customizationsSupported.length);
        for (ModelCustomization value : customizationsSupported) {
            customizationsSupportedCopy.add(value.toString());
        }
        if (this.getCustomizationsSupported() == null) {
            this.setCustomizationsSupported(customizationsSupportedCopy);
        } else {
            this.getCustomizationsSupported().addAll(customizationsSupportedCopy);
        }
        return this;
    }

    public List<String> getInferenceTypesSupported() {
        return this.inferenceTypesSupported;
    }

    public void setInferenceTypesSupported(Collection<String> inferenceTypesSupported) {
        if (inferenceTypesSupported == null) {
            this.inferenceTypesSupported = null;
            return;
        }
        this.inferenceTypesSupported = new ArrayList<String>(inferenceTypesSupported);
    }

    public FoundationModelSummary withInferenceTypesSupported(String ... inferenceTypesSupported) {
        if (this.inferenceTypesSupported == null) {
            this.setInferenceTypesSupported(new ArrayList<String>(inferenceTypesSupported.length));
        }
        for (String ele : inferenceTypesSupported) {
            this.inferenceTypesSupported.add(ele);
        }
        return this;
    }

    public FoundationModelSummary withInferenceTypesSupported(Collection<String> inferenceTypesSupported) {
        this.setInferenceTypesSupported(inferenceTypesSupported);
        return this;
    }

    public FoundationModelSummary withInferenceTypesSupported(InferenceType ... inferenceTypesSupported) {
        ArrayList<String> inferenceTypesSupportedCopy = new ArrayList<String>(inferenceTypesSupported.length);
        for (InferenceType value : inferenceTypesSupported) {
            inferenceTypesSupportedCopy.add(value.toString());
        }
        if (this.getInferenceTypesSupported() == null) {
            this.setInferenceTypesSupported(inferenceTypesSupportedCopy);
        } else {
            this.getInferenceTypesSupported().addAll(inferenceTypesSupportedCopy);
        }
        return this;
    }

    public void setModelLifecycle(FoundationModelLifecycle modelLifecycle) {
        this.modelLifecycle = modelLifecycle;
    }

    public FoundationModelLifecycle getModelLifecycle() {
        return this.modelLifecycle;
    }

    public FoundationModelSummary withModelLifecycle(FoundationModelLifecycle modelLifecycle) {
        this.setModelLifecycle(modelLifecycle);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelArn() != null) {
            sb.append("ModelArn: ").append(this.getModelArn()).append(",");
        }
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getProviderName() != null) {
            sb.append("ProviderName: ").append(this.getProviderName()).append(",");
        }
        if (this.getInputModalities() != null) {
            sb.append("InputModalities: ").append(this.getInputModalities()).append(",");
        }
        if (this.getOutputModalities() != null) {
            sb.append("OutputModalities: ").append(this.getOutputModalities()).append(",");
        }
        if (this.getResponseStreamingSupported() != null) {
            sb.append("ResponseStreamingSupported: ").append(this.getResponseStreamingSupported()).append(",");
        }
        if (this.getCustomizationsSupported() != null) {
            sb.append("CustomizationsSupported: ").append(this.getCustomizationsSupported()).append(",");
        }
        if (this.getInferenceTypesSupported() != null) {
            sb.append("InferenceTypesSupported: ").append(this.getInferenceTypesSupported()).append(",");
        }
        if (this.getModelLifecycle() != null) {
            sb.append("ModelLifecycle: ").append(this.getModelLifecycle());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FoundationModelSummary)) {
            return false;
        }
        FoundationModelSummary other = (FoundationModelSummary)obj;
        if (other.getModelArn() == null ^ this.getModelArn() == null) {
            return false;
        }
        if (other.getModelArn() != null && !other.getModelArn().equals(this.getModelArn())) {
            return false;
        }
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getProviderName() == null ^ this.getProviderName() == null) {
            return false;
        }
        if (other.getProviderName() != null && !other.getProviderName().equals(this.getProviderName())) {
            return false;
        }
        if (other.getInputModalities() == null ^ this.getInputModalities() == null) {
            return false;
        }
        if (other.getInputModalities() != null && !other.getInputModalities().equals(this.getInputModalities())) {
            return false;
        }
        if (other.getOutputModalities() == null ^ this.getOutputModalities() == null) {
            return false;
        }
        if (other.getOutputModalities() != null && !other.getOutputModalities().equals(this.getOutputModalities())) {
            return false;
        }
        if (other.getResponseStreamingSupported() == null ^ this.getResponseStreamingSupported() == null) {
            return false;
        }
        if (other.getResponseStreamingSupported() != null && !other.getResponseStreamingSupported().equals(this.getResponseStreamingSupported())) {
            return false;
        }
        if (other.getCustomizationsSupported() == null ^ this.getCustomizationsSupported() == null) {
            return false;
        }
        if (other.getCustomizationsSupported() != null && !other.getCustomizationsSupported().equals(this.getCustomizationsSupported())) {
            return false;
        }
        if (other.getInferenceTypesSupported() == null ^ this.getInferenceTypesSupported() == null) {
            return false;
        }
        if (other.getInferenceTypesSupported() != null && !other.getInferenceTypesSupported().equals(this.getInferenceTypesSupported())) {
            return false;
        }
        if (other.getModelLifecycle() == null ^ this.getModelLifecycle() == null) {
            return false;
        }
        return other.getModelLifecycle() == null || other.getModelLifecycle().equals(this.getModelLifecycle());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelArn() == null ? 0 : this.getModelArn().hashCode());
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getProviderName() == null ? 0 : this.getProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getInputModalities() == null ? 0 : this.getInputModalities().hashCode());
        hashCode = 31 * hashCode + (this.getOutputModalities() == null ? 0 : this.getOutputModalities().hashCode());
        hashCode = 31 * hashCode + (this.getResponseStreamingSupported() == null ? 0 : this.getResponseStreamingSupported().hashCode());
        hashCode = 31 * hashCode + (this.getCustomizationsSupported() == null ? 0 : this.getCustomizationsSupported().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceTypesSupported() == null ? 0 : this.getInferenceTypesSupported().hashCode());
        hashCode = 31 * hashCode + (this.getModelLifecycle() == null ? 0 : this.getModelLifecycle().hashCode());
        return hashCode;
    }

    public FoundationModelSummary clone() {
        try {
            return (FoundationModelSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FoundationModelSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

