/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.GuardrailManagedWords;
import com.amazonaws.services.bedrock.model.GuardrailWord;
import com.amazonaws.services.bedrock.model.transform.GuardrailWordPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuardrailWordPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private List<GuardrailWord> words;
    private List<GuardrailManagedWords> managedWordLists;

    public List<GuardrailWord> getWords() {
        return this.words;
    }

    public void setWords(Collection<GuardrailWord> words) {
        if (words == null) {
            this.words = null;
            return;
        }
        this.words = new ArrayList<GuardrailWord>(words);
    }

    public GuardrailWordPolicy withWords(GuardrailWord ... words) {
        if (this.words == null) {
            this.setWords(new ArrayList<GuardrailWord>(words.length));
        }
        for (GuardrailWord ele : words) {
            this.words.add(ele);
        }
        return this;
    }

    public GuardrailWordPolicy withWords(Collection<GuardrailWord> words) {
        this.setWords(words);
        return this;
    }

    public List<GuardrailManagedWords> getManagedWordLists() {
        return this.managedWordLists;
    }

    public void setManagedWordLists(Collection<GuardrailManagedWords> managedWordLists) {
        if (managedWordLists == null) {
            this.managedWordLists = null;
            return;
        }
        this.managedWordLists = new ArrayList<GuardrailManagedWords>(managedWordLists);
    }

    public GuardrailWordPolicy withManagedWordLists(GuardrailManagedWords ... managedWordLists) {
        if (this.managedWordLists == null) {
            this.setManagedWordLists(new ArrayList<GuardrailManagedWords>(managedWordLists.length));
        }
        for (GuardrailManagedWords ele : managedWordLists) {
            this.managedWordLists.add(ele);
        }
        return this;
    }

    public GuardrailWordPolicy withManagedWordLists(Collection<GuardrailManagedWords> managedWordLists) {
        this.setManagedWordLists(managedWordLists);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWords() != null) {
            sb.append("Words: ").append(this.getWords()).append(",");
        }
        if (this.getManagedWordLists() != null) {
            sb.append("ManagedWordLists: ").append(this.getManagedWordLists());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordPolicy)) {
            return false;
        }
        GuardrailWordPolicy other = (GuardrailWordPolicy)obj;
        if (other.getWords() == null ^ this.getWords() == null) {
            return false;
        }
        if (other.getWords() != null && !other.getWords().equals(this.getWords())) {
            return false;
        }
        if (other.getManagedWordLists() == null ^ this.getManagedWordLists() == null) {
            return false;
        }
        return other.getManagedWordLists() == null || other.getManagedWordLists().equals(this.getManagedWordLists());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWords() == null ? 0 : this.getWords().hashCode());
        hashCode = 31 * hashCode + (this.getManagedWordLists() == null ? 0 : this.getManagedWordLists().hashCode());
        return hashCode;
    }

    public GuardrailWordPolicy clone() {
        try {
            return (GuardrailWordPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GuardrailWordPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

