/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cleanrooms.model.CollaborationQueryLogStatus;
import com.amazonaws.services.cleanrooms.model.DataEncryptionMetadata;
import com.amazonaws.services.cleanrooms.model.MemberAbility;
import com.amazonaws.services.cleanrooms.model.MemberSpecification;
import com.amazonaws.services.cleanrooms.model.PaymentConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateCollaborationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<MemberSpecification> members;
    private String name;
    private String description;
    private List<String> creatorMemberAbilities;
    private String creatorDisplayName;
    private DataEncryptionMetadata dataEncryptionMetadata;
    private String queryLogStatus;
    private Map<String, String> tags;
    private PaymentConfiguration creatorPaymentConfiguration;

    public List<MemberSpecification> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<MemberSpecification> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<MemberSpecification>(members);
    }

    public CreateCollaborationRequest withMembers(MemberSpecification ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<MemberSpecification>(members.length));
        }
        for (MemberSpecification ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public CreateCollaborationRequest withMembers(Collection<MemberSpecification> members) {
        this.setMembers(members);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCollaborationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateCollaborationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getCreatorMemberAbilities() {
        return this.creatorMemberAbilities;
    }

    public void setCreatorMemberAbilities(Collection<String> creatorMemberAbilities) {
        if (creatorMemberAbilities == null) {
            this.creatorMemberAbilities = null;
            return;
        }
        this.creatorMemberAbilities = new ArrayList<String>(creatorMemberAbilities);
    }

    public CreateCollaborationRequest withCreatorMemberAbilities(String ... creatorMemberAbilities) {
        if (this.creatorMemberAbilities == null) {
            this.setCreatorMemberAbilities(new ArrayList<String>(creatorMemberAbilities.length));
        }
        for (String ele : creatorMemberAbilities) {
            this.creatorMemberAbilities.add(ele);
        }
        return this;
    }

    public CreateCollaborationRequest withCreatorMemberAbilities(Collection<String> creatorMemberAbilities) {
        this.setCreatorMemberAbilities(creatorMemberAbilities);
        return this;
    }

    public CreateCollaborationRequest withCreatorMemberAbilities(MemberAbility ... creatorMemberAbilities) {
        ArrayList<String> creatorMemberAbilitiesCopy = new ArrayList<String>(creatorMemberAbilities.length);
        for (MemberAbility value : creatorMemberAbilities) {
            creatorMemberAbilitiesCopy.add(value.toString());
        }
        if (this.getCreatorMemberAbilities() == null) {
            this.setCreatorMemberAbilities(creatorMemberAbilitiesCopy);
        } else {
            this.getCreatorMemberAbilities().addAll(creatorMemberAbilitiesCopy);
        }
        return this;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public CreateCollaborationRequest withCreatorDisplayName(String creatorDisplayName) {
        this.setCreatorDisplayName(creatorDisplayName);
        return this;
    }

    public void setDataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata) {
        this.dataEncryptionMetadata = dataEncryptionMetadata;
    }

    public DataEncryptionMetadata getDataEncryptionMetadata() {
        return this.dataEncryptionMetadata;
    }

    public CreateCollaborationRequest withDataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata) {
        this.setDataEncryptionMetadata(dataEncryptionMetadata);
        return this;
    }

    public void setQueryLogStatus(String queryLogStatus) {
        this.queryLogStatus = queryLogStatus;
    }

    public String getQueryLogStatus() {
        return this.queryLogStatus;
    }

    public CreateCollaborationRequest withQueryLogStatus(String queryLogStatus) {
        this.setQueryLogStatus(queryLogStatus);
        return this;
    }

    public CreateCollaborationRequest withQueryLogStatus(CollaborationQueryLogStatus queryLogStatus) {
        this.queryLogStatus = queryLogStatus.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateCollaborationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateCollaborationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateCollaborationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setCreatorPaymentConfiguration(PaymentConfiguration creatorPaymentConfiguration) {
        this.creatorPaymentConfiguration = creatorPaymentConfiguration;
    }

    public PaymentConfiguration getCreatorPaymentConfiguration() {
        return this.creatorPaymentConfiguration;
    }

    public CreateCollaborationRequest withCreatorPaymentConfiguration(PaymentConfiguration creatorPaymentConfiguration) {
        this.setCreatorPaymentConfiguration(creatorPaymentConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCreatorMemberAbilities() != null) {
            sb.append("CreatorMemberAbilities: ").append(this.getCreatorMemberAbilities()).append(",");
        }
        if (this.getCreatorDisplayName() != null) {
            sb.append("CreatorDisplayName: ").append(this.getCreatorDisplayName()).append(",");
        }
        if (this.getDataEncryptionMetadata() != null) {
            sb.append("DataEncryptionMetadata: ").append(this.getDataEncryptionMetadata()).append(",");
        }
        if (this.getQueryLogStatus() != null) {
            sb.append("QueryLogStatus: ").append(this.getQueryLogStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreatorPaymentConfiguration() != null) {
            sb.append("CreatorPaymentConfiguration: ").append(this.getCreatorPaymentConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollaborationRequest)) {
            return false;
        }
        CreateCollaborationRequest other = (CreateCollaborationRequest)obj;
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        if (other.getMembers() != null && !other.getMembers().equals(this.getMembers())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatorMemberAbilities() == null ^ this.getCreatorMemberAbilities() == null) {
            return false;
        }
        if (other.getCreatorMemberAbilities() != null && !other.getCreatorMemberAbilities().equals(this.getCreatorMemberAbilities())) {
            return false;
        }
        if (other.getCreatorDisplayName() == null ^ this.getCreatorDisplayName() == null) {
            return false;
        }
        if (other.getCreatorDisplayName() != null && !other.getCreatorDisplayName().equals(this.getCreatorDisplayName())) {
            return false;
        }
        if (other.getDataEncryptionMetadata() == null ^ this.getDataEncryptionMetadata() == null) {
            return false;
        }
        if (other.getDataEncryptionMetadata() != null && !other.getDataEncryptionMetadata().equals(this.getDataEncryptionMetadata())) {
            return false;
        }
        if (other.getQueryLogStatus() == null ^ this.getQueryLogStatus() == null) {
            return false;
        }
        if (other.getQueryLogStatus() != null && !other.getQueryLogStatus().equals(this.getQueryLogStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreatorPaymentConfiguration() == null ^ this.getCreatorPaymentConfiguration() == null) {
            return false;
        }
        return other.getCreatorPaymentConfiguration() == null || other.getCreatorPaymentConfiguration().equals(this.getCreatorPaymentConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorMemberAbilities() == null ? 0 : this.getCreatorMemberAbilities().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorDisplayName() == null ? 0 : this.getCreatorDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDataEncryptionMetadata() == null ? 0 : this.getDataEncryptionMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getQueryLogStatus() == null ? 0 : this.getQueryLogStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorPaymentConfiguration() == null ? 0 : this.getCreatorPaymentConfiguration().hashCode());
        return hashCode;
    }

    public CreateCollaborationRequest clone() {
        return (CreateCollaborationRequest)super.clone();
    }
}

