/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.ImportSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StartImportRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> destinations;
    private ImportSource importSource;
    private Date startEventTime;
    private Date endEventTime;
    private String importId;

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new SdkInternalList();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new SdkInternalList(destinations);
    }

    public StartImportRequest withDestinations(String ... destinations) {
        if (this.destinations == null) {
            this.setDestinations((Collection<String>)new SdkInternalList(destinations.length));
        }
        for (String ele : destinations) {
            this.destinations.add((Object)ele);
        }
        return this;
    }

    public StartImportRequest withDestinations(Collection<String> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setImportSource(ImportSource importSource) {
        this.importSource = importSource;
    }

    public ImportSource getImportSource() {
        return this.importSource;
    }

    public StartImportRequest withImportSource(ImportSource importSource) {
        this.setImportSource(importSource);
        return this;
    }

    public void setStartEventTime(Date startEventTime) {
        this.startEventTime = startEventTime;
    }

    public Date getStartEventTime() {
        return this.startEventTime;
    }

    public StartImportRequest withStartEventTime(Date startEventTime) {
        this.setStartEventTime(startEventTime);
        return this;
    }

    public void setEndEventTime(Date endEventTime) {
        this.endEventTime = endEventTime;
    }

    public Date getEndEventTime() {
        return this.endEventTime;
    }

    public StartImportRequest withEndEventTime(Date endEventTime) {
        this.setEndEventTime(endEventTime);
        return this;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public String getImportId() {
        return this.importId;
    }

    public StartImportRequest withImportId(String importId) {
        this.setImportId(importId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getImportSource() != null) {
            sb.append("ImportSource: ").append(this.getImportSource()).append(",");
        }
        if (this.getStartEventTime() != null) {
            sb.append("StartEventTime: ").append(this.getStartEventTime()).append(",");
        }
        if (this.getEndEventTime() != null) {
            sb.append("EndEventTime: ").append(this.getEndEventTime()).append(",");
        }
        if (this.getImportId() != null) {
            sb.append("ImportId: ").append(this.getImportId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getImportSource() == null ^ this.getImportSource() == null) {
            return false;
        }
        if (other.getImportSource() != null && !other.getImportSource().equals(this.getImportSource())) {
            return false;
        }
        if (other.getStartEventTime() == null ^ this.getStartEventTime() == null) {
            return false;
        }
        if (other.getStartEventTime() != null && !other.getStartEventTime().equals(this.getStartEventTime())) {
            return false;
        }
        if (other.getEndEventTime() == null ^ this.getEndEventTime() == null) {
            return false;
        }
        if (other.getEndEventTime() != null && !other.getEndEventTime().equals(this.getEndEventTime())) {
            return false;
        }
        if (other.getImportId() == null ^ this.getImportId() == null) {
            return false;
        }
        return other.getImportId() == null || other.getImportId().equals(this.getImportId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getImportSource() == null ? 0 : this.getImportSource().hashCode());
        hashCode = 31 * hashCode + (this.getStartEventTime() == null ? 0 : this.getStartEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndEventTime() == null ? 0 : this.getEndEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getImportId() == null ? 0 : this.getImportId().hashCode());
        return hashCode;
    }

    public StartImportRequest clone() {
        return (StartImportRequest)super.clone();
    }
}

