/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.connect.AmazonConnect;
import com.amazonaws.services.connect.AmazonConnectClientBuilder;
import com.amazonaws.services.connect.model.AmazonConnectException;
import com.amazonaws.services.connect.model.CreateUserRequest;
import com.amazonaws.services.connect.model.CreateUserResult;
import com.amazonaws.services.connect.model.DeleteUserRequest;
import com.amazonaws.services.connect.model.DeleteUserResult;
import com.amazonaws.services.connect.model.DescribeUserHierarchyGroupRequest;
import com.amazonaws.services.connect.model.DescribeUserHierarchyGroupResult;
import com.amazonaws.services.connect.model.DescribeUserHierarchyStructureRequest;
import com.amazonaws.services.connect.model.DescribeUserHierarchyStructureResult;
import com.amazonaws.services.connect.model.DescribeUserRequest;
import com.amazonaws.services.connect.model.DescribeUserResult;
import com.amazonaws.services.connect.model.GetContactAttributesRequest;
import com.amazonaws.services.connect.model.GetContactAttributesResult;
import com.amazonaws.services.connect.model.GetCurrentMetricDataRequest;
import com.amazonaws.services.connect.model.GetCurrentMetricDataResult;
import com.amazonaws.services.connect.model.GetFederationTokenRequest;
import com.amazonaws.services.connect.model.GetFederationTokenResult;
import com.amazonaws.services.connect.model.GetMetricDataRequest;
import com.amazonaws.services.connect.model.GetMetricDataResult;
import com.amazonaws.services.connect.model.ListContactFlowsRequest;
import com.amazonaws.services.connect.model.ListContactFlowsResult;
import com.amazonaws.services.connect.model.ListHoursOfOperationsRequest;
import com.amazonaws.services.connect.model.ListHoursOfOperationsResult;
import com.amazonaws.services.connect.model.ListPhoneNumbersRequest;
import com.amazonaws.services.connect.model.ListPhoneNumbersResult;
import com.amazonaws.services.connect.model.ListQueuesRequest;
import com.amazonaws.services.connect.model.ListQueuesResult;
import com.amazonaws.services.connect.model.ListRoutingProfilesRequest;
import com.amazonaws.services.connect.model.ListRoutingProfilesResult;
import com.amazonaws.services.connect.model.ListSecurityProfilesRequest;
import com.amazonaws.services.connect.model.ListSecurityProfilesResult;
import com.amazonaws.services.connect.model.ListUserHierarchyGroupsRequest;
import com.amazonaws.services.connect.model.ListUserHierarchyGroupsResult;
import com.amazonaws.services.connect.model.ListUsersRequest;
import com.amazonaws.services.connect.model.ListUsersResult;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactRequest;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactResult;
import com.amazonaws.services.connect.model.StopContactRequest;
import com.amazonaws.services.connect.model.StopContactResult;
import com.amazonaws.services.connect.model.UpdateContactAttributesRequest;
import com.amazonaws.services.connect.model.UpdateContactAttributesResult;
import com.amazonaws.services.connect.model.UpdateUserHierarchyRequest;
import com.amazonaws.services.connect.model.UpdateUserHierarchyResult;
import com.amazonaws.services.connect.model.UpdateUserIdentityInfoRequest;
import com.amazonaws.services.connect.model.UpdateUserIdentityInfoResult;
import com.amazonaws.services.connect.model.UpdateUserPhoneConfigRequest;
import com.amazonaws.services.connect.model.UpdateUserPhoneConfigResult;
import com.amazonaws.services.connect.model.UpdateUserRoutingProfileRequest;
import com.amazonaws.services.connect.model.UpdateUserRoutingProfileResult;
import com.amazonaws.services.connect.model.UpdateUserSecurityProfilesRequest;
import com.amazonaws.services.connect.model.UpdateUserSecurityProfilesResult;
import com.amazonaws.services.connect.model.transform.ContactNotFoundExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.CreateUserRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.CreateUserResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.DeleteUserRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.DeleteUserResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserHierarchyGroupRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserHierarchyGroupResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserHierarchyStructureRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserHierarchyStructureResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.DescribeUserResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.DestinationNotAllowedExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.DuplicateResourceExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.GetContactAttributesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.GetContactAttributesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.GetCurrentMetricDataRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.GetCurrentMetricDataResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.GetFederationTokenRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.GetFederationTokenResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.GetMetricDataRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.GetMetricDataResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListContactFlowsRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListContactFlowsResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListHoursOfOperationsRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListHoursOfOperationsResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListPhoneNumbersRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListPhoneNumbersResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListQueuesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListQueuesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListRoutingProfilesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListRoutingProfilesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListSecurityProfilesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListSecurityProfilesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListUserHierarchyGroupsRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListUserHierarchyGroupsResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ListUsersRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.ListUsersResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.OutboundContactNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.StartOutboundVoiceContactRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.StartOutboundVoiceContactResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.StopContactRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.StopContactResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateContactAttributesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateContactAttributesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserHierarchyRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserHierarchyResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserIdentityInfoRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserIdentityInfoResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserPhoneConfigRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserPhoneConfigResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserRoutingProfileRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserRoutingProfileResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserSecurityProfilesRequestProtocolMarshaller;
import com.amazonaws.services.connect.model.transform.UpdateUserSecurityProfilesResultJsonUnmarshaller;
import com.amazonaws.services.connect.model.transform.UserNotFoundExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonConnectClient
extends AmazonWebServiceClient
implements AmazonConnect {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonConnect.class);
    private static final String DEFAULT_SIGNING_NAME = "connect";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OutboundContactNotPermittedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OutboundContactNotPermittedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContactNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ContactNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateResourceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DuplicateResourceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UserNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UserNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DestinationNotAllowedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DestinationNotAllowedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonConnectException.class));

    public static AmazonConnectClientBuilder builder() {
        return AmazonConnectClientBuilder.standard();
    }

    AmazonConnectClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonConnectClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("connect.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/connect/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/connect/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        request = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executeCreateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateUserResult executeCreateUser(CreateUserRequest createUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateUserRequestProtocolMarshaller(protocolFactory).marshall((CreateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)createUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateUserResult createUserResult = (CreateUserResult)response.getAwsResponse();
            return createUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        request = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executeDeleteUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteUserResult executeDeleteUser(DeleteUserRequest deleteUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteUserRequestProtocolMarshaller(protocolFactory).marshall((DeleteUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteUserResult deleteUserResult = (DeleteUserResult)response.getAwsResponse();
            return deleteUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        request = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executeDescribeUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserResult executeDescribeUser(DescribeUserRequest describeUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserResult describeUserResult = (DescribeUserResult)response.getAwsResponse();
            return describeUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserHierarchyGroupResult describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest request) {
        request = (DescribeUserHierarchyGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeUserHierarchyGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserHierarchyGroupResult executeDescribeUserHierarchyGroup(DescribeUserHierarchyGroupRequest describeUserHierarchyGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserHierarchyGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserHierarchyGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserHierarchyGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserHierarchyGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserHierarchyGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUserHierarchyGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserHierarchyGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserHierarchyGroupResult describeUserHierarchyGroupResult = (DescribeUserHierarchyGroupResult)response.getAwsResponse();
            return describeUserHierarchyGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserHierarchyStructureResult describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest request) {
        request = (DescribeUserHierarchyStructureRequest)this.beforeClientExecution(request);
        return this.executeDescribeUserHierarchyStructure(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserHierarchyStructureResult executeDescribeUserHierarchyStructure(DescribeUserHierarchyStructureRequest describeUserHierarchyStructureRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserHierarchyStructureRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserHierarchyStructureRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserHierarchyStructureRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserHierarchyStructureRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserHierarchyStructureRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUserHierarchyStructure");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserHierarchyStructureResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserHierarchyStructureResult describeUserHierarchyStructureResult = (DescribeUserHierarchyStructureResult)response.getAwsResponse();
            return describeUserHierarchyStructureResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContactAttributesResult getContactAttributes(GetContactAttributesRequest request) {
        request = (GetContactAttributesRequest)this.beforeClientExecution(request);
        return this.executeGetContactAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContactAttributesResult executeGetContactAttributes(GetContactAttributesRequest getContactAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactAttributesRequestProtocolMarshaller(protocolFactory).marshall((GetContactAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContactAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetContactAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContactAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactAttributesResult getContactAttributesResult = (GetContactAttributesResult)response.getAwsResponse();
            return getContactAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCurrentMetricDataResult getCurrentMetricData(GetCurrentMetricDataRequest request) {
        request = (GetCurrentMetricDataRequest)this.beforeClientExecution(request);
        return this.executeGetCurrentMetricData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCurrentMetricDataResult executeGetCurrentMetricData(GetCurrentMetricDataRequest getCurrentMetricDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCurrentMetricDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCurrentMetricDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCurrentMetricDataRequestProtocolMarshaller(protocolFactory).marshall((GetCurrentMetricDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCurrentMetricDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCurrentMetricData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCurrentMetricDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCurrentMetricDataResult getCurrentMetricDataResult = (GetCurrentMetricDataResult)response.getAwsResponse();
            return getCurrentMetricDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFederationTokenResult getFederationToken(GetFederationTokenRequest request) {
        request = (GetFederationTokenRequest)this.beforeClientExecution(request);
        return this.executeGetFederationToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFederationTokenResult executeGetFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFederationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFederationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFederationTokenRequestProtocolMarshaller(protocolFactory).marshall((GetFederationTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFederationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFederationToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFederationTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFederationTokenResult getFederationTokenResult = (GetFederationTokenResult)response.getAwsResponse();
            return getFederationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMetricDataResult getMetricData(GetMetricDataRequest request) {
        request = (GetMetricDataRequest)this.beforeClientExecution(request);
        return this.executeGetMetricData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMetricDataResult executeGetMetricData(GetMetricDataRequest getMetricDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMetricDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMetricDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMetricDataRequestProtocolMarshaller(protocolFactory).marshall((GetMetricDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMetricDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMetricData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMetricDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMetricDataResult getMetricDataResult = (GetMetricDataResult)response.getAwsResponse();
            return getMetricDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContactFlowsResult listContactFlows(ListContactFlowsRequest request) {
        request = (ListContactFlowsRequest)this.beforeClientExecution(request);
        return this.executeListContactFlows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContactFlowsResult executeListContactFlows(ListContactFlowsRequest listContactFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContactFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContactFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContactFlowsRequestProtocolMarshaller(protocolFactory).marshall((ListContactFlowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContactFlowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContactFlows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContactFlowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContactFlowsResult listContactFlowsResult = (ListContactFlowsResult)response.getAwsResponse();
            return listContactFlowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHoursOfOperationsResult listHoursOfOperations(ListHoursOfOperationsRequest request) {
        request = (ListHoursOfOperationsRequest)this.beforeClientExecution(request);
        return this.executeListHoursOfOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHoursOfOperationsResult executeListHoursOfOperations(ListHoursOfOperationsRequest listHoursOfOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHoursOfOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHoursOfOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHoursOfOperationsRequestProtocolMarshaller(protocolFactory).marshall((ListHoursOfOperationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHoursOfOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHoursOfOperations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHoursOfOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHoursOfOperationsResult listHoursOfOperationsResult = (ListHoursOfOperationsResult)response.getAwsResponse();
            return listHoursOfOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPhoneNumbersResult listPhoneNumbers(ListPhoneNumbersRequest request) {
        request = (ListPhoneNumbersRequest)this.beforeClientExecution(request);
        return this.executeListPhoneNumbers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPhoneNumbersResult executeListPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPhoneNumbersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPhoneNumbersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPhoneNumbersRequestProtocolMarshaller(protocolFactory).marshall((ListPhoneNumbersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPhoneNumbersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPhoneNumbers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPhoneNumbersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPhoneNumbersResult listPhoneNumbersResult = (ListPhoneNumbersResult)response.getAwsResponse();
            return listPhoneNumbersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        request = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executeListQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueuesResult executeListQueues(ListQueuesRequest listQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueuesRequestProtocolMarshaller(protocolFactory).marshall((ListQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQueuesResult listQueuesResult = (ListQueuesResult)response.getAwsResponse();
            return listQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRoutingProfilesResult listRoutingProfiles(ListRoutingProfilesRequest request) {
        request = (ListRoutingProfilesRequest)this.beforeClientExecution(request);
        return this.executeListRoutingProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRoutingProfilesResult executeListRoutingProfiles(ListRoutingProfilesRequest listRoutingProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRoutingProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRoutingProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRoutingProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListRoutingProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRoutingProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRoutingProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRoutingProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRoutingProfilesResult listRoutingProfilesResult = (ListRoutingProfilesResult)response.getAwsResponse();
            return listRoutingProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSecurityProfilesResult listSecurityProfiles(ListSecurityProfilesRequest request) {
        request = (ListSecurityProfilesRequest)this.beforeClientExecution(request);
        return this.executeListSecurityProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSecurityProfilesResult executeListSecurityProfiles(ListSecurityProfilesRequest listSecurityProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSecurityProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSecurityProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSecurityProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListSecurityProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSecurityProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSecurityProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSecurityProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSecurityProfilesResult listSecurityProfilesResult = (ListSecurityProfilesResult)response.getAwsResponse();
            return listSecurityProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUserHierarchyGroupsResult listUserHierarchyGroups(ListUserHierarchyGroupsRequest request) {
        request = (ListUserHierarchyGroupsRequest)this.beforeClientExecution(request);
        return this.executeListUserHierarchyGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUserHierarchyGroupsResult executeListUserHierarchyGroups(ListUserHierarchyGroupsRequest listUserHierarchyGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUserHierarchyGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUserHierarchyGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUserHierarchyGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListUserHierarchyGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUserHierarchyGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUserHierarchyGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUserHierarchyGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUserHierarchyGroupsResult listUserHierarchyGroupsResult = (ListUserHierarchyGroupsResult)response.getAwsResponse();
            return listUserHierarchyGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        request = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executeListUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsersResult executeListUsers(ListUsersRequest listUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsersRequestProtocolMarshaller(protocolFactory).marshall((ListUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsersResult listUsersResult = (ListUsersResult)response.getAwsResponse();
            return listUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartOutboundVoiceContactResult startOutboundVoiceContact(StartOutboundVoiceContactRequest request) {
        request = (StartOutboundVoiceContactRequest)this.beforeClientExecution(request);
        return this.executeStartOutboundVoiceContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartOutboundVoiceContactResult executeStartOutboundVoiceContact(StartOutboundVoiceContactRequest startOutboundVoiceContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startOutboundVoiceContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartOutboundVoiceContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartOutboundVoiceContactRequestProtocolMarshaller(protocolFactory).marshall((StartOutboundVoiceContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)startOutboundVoiceContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartOutboundVoiceContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartOutboundVoiceContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartOutboundVoiceContactResult startOutboundVoiceContactResult = (StartOutboundVoiceContactResult)response.getAwsResponse();
            return startOutboundVoiceContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopContactResult stopContact(StopContactRequest request) {
        request = (StopContactRequest)this.beforeClientExecution(request);
        return this.executeStopContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopContactResult executeStopContact(StopContactRequest stopContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopContactRequestProtocolMarshaller(protocolFactory).marshall((StopContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopContactResult stopContactResult = (StopContactResult)response.getAwsResponse();
            return stopContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateContactAttributesResult updateContactAttributes(UpdateContactAttributesRequest request) {
        request = (UpdateContactAttributesRequest)this.beforeClientExecution(request);
        return this.executeUpdateContactAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateContactAttributesResult executeUpdateContactAttributes(UpdateContactAttributesRequest updateContactAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContactAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContactAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContactAttributesRequestProtocolMarshaller(protocolFactory).marshall((UpdateContactAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContactAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateContactAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateContactAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContactAttributesResult updateContactAttributesResult = (UpdateContactAttributesResult)response.getAwsResponse();
            return updateContactAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserHierarchyResult updateUserHierarchy(UpdateUserHierarchyRequest request) {
        request = (UpdateUserHierarchyRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserHierarchy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserHierarchyResult executeUpdateUserHierarchy(UpdateUserHierarchyRequest updateUserHierarchyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserHierarchyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserHierarchyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserHierarchyRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserHierarchyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserHierarchyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserHierarchy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserHierarchyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserHierarchyResult updateUserHierarchyResult = (UpdateUserHierarchyResult)response.getAwsResponse();
            return updateUserHierarchyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserIdentityInfoResult updateUserIdentityInfo(UpdateUserIdentityInfoRequest request) {
        request = (UpdateUserIdentityInfoRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserIdentityInfo(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserIdentityInfoResult executeUpdateUserIdentityInfo(UpdateUserIdentityInfoRequest updateUserIdentityInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserIdentityInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserIdentityInfoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserIdentityInfoRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserIdentityInfoRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserIdentityInfoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserIdentityInfo");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserIdentityInfoResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserIdentityInfoResult updateUserIdentityInfoResult = (UpdateUserIdentityInfoResult)response.getAwsResponse();
            return updateUserIdentityInfoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserPhoneConfigResult updateUserPhoneConfig(UpdateUserPhoneConfigRequest request) {
        request = (UpdateUserPhoneConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserPhoneConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserPhoneConfigResult executeUpdateUserPhoneConfig(UpdateUserPhoneConfigRequest updateUserPhoneConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserPhoneConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserPhoneConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserPhoneConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserPhoneConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserPhoneConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserPhoneConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserPhoneConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserPhoneConfigResult updateUserPhoneConfigResult = (UpdateUserPhoneConfigResult)response.getAwsResponse();
            return updateUserPhoneConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserRoutingProfileResult updateUserRoutingProfile(UpdateUserRoutingProfileRequest request) {
        request = (UpdateUserRoutingProfileRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserRoutingProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserRoutingProfileResult executeUpdateUserRoutingProfile(UpdateUserRoutingProfileRequest updateUserRoutingProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserRoutingProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserRoutingProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserRoutingProfileRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserRoutingProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserRoutingProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserRoutingProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserRoutingProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserRoutingProfileResult updateUserRoutingProfileResult = (UpdateUserRoutingProfileResult)response.getAwsResponse();
            return updateUserRoutingProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserSecurityProfilesResult updateUserSecurityProfiles(UpdateUserSecurityProfilesRequest request) {
        request = (UpdateUserSecurityProfilesRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserSecurityProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserSecurityProfilesResult executeUpdateUserSecurityProfiles(UpdateUserSecurityProfilesRequest updateUserSecurityProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserSecurityProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserSecurityProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserSecurityProfilesRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserSecurityProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserSecurityProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Connect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserSecurityProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserSecurityProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserSecurityProfilesResult updateUserSecurityProfilesResult = (UpdateUserSecurityProfilesResult)response.getAwsResponse();
            return updateUserSecurityProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

