/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.HdfsAuthenticationType;
import com.amazonaws.services.datasync.model.HdfsNameNode;
import com.amazonaws.services.datasync.model.QopConfiguration;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationHdfsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String subdirectory;
    private List<HdfsNameNode> nameNodes;
    private Integer blockSize;
    private Integer replicationFactor;
    private String kmsKeyProviderUri;
    private QopConfiguration qopConfiguration;
    private String authenticationType;
    private String simpleUser;
    private String kerberosPrincipal;
    private ByteBuffer kerberosKeytab;
    private ByteBuffer kerberosKrb5Conf;
    private List<String> agentArns;
    private List<TagListEntry> tags;

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationHdfsRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public List<HdfsNameNode> getNameNodes() {
        return this.nameNodes;
    }

    public void setNameNodes(Collection<HdfsNameNode> nameNodes) {
        if (nameNodes == null) {
            this.nameNodes = null;
            return;
        }
        this.nameNodes = new ArrayList<HdfsNameNode>(nameNodes);
    }

    public CreateLocationHdfsRequest withNameNodes(HdfsNameNode ... nameNodes) {
        if (this.nameNodes == null) {
            this.setNameNodes(new ArrayList<HdfsNameNode>(nameNodes.length));
        }
        for (HdfsNameNode ele : nameNodes) {
            this.nameNodes.add(ele);
        }
        return this;
    }

    public CreateLocationHdfsRequest withNameNodes(Collection<HdfsNameNode> nameNodes) {
        this.setNameNodes(nameNodes);
        return this;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public CreateLocationHdfsRequest withBlockSize(Integer blockSize) {
        this.setBlockSize(blockSize);
        return this;
    }

    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public CreateLocationHdfsRequest withReplicationFactor(Integer replicationFactor) {
        this.setReplicationFactor(replicationFactor);
        return this;
    }

    public void setKmsKeyProviderUri(String kmsKeyProviderUri) {
        this.kmsKeyProviderUri = kmsKeyProviderUri;
    }

    public String getKmsKeyProviderUri() {
        return this.kmsKeyProviderUri;
    }

    public CreateLocationHdfsRequest withKmsKeyProviderUri(String kmsKeyProviderUri) {
        this.setKmsKeyProviderUri(kmsKeyProviderUri);
        return this;
    }

    public void setQopConfiguration(QopConfiguration qopConfiguration) {
        this.qopConfiguration = qopConfiguration;
    }

    public QopConfiguration getQopConfiguration() {
        return this.qopConfiguration;
    }

    public CreateLocationHdfsRequest withQopConfiguration(QopConfiguration qopConfiguration) {
        this.setQopConfiguration(qopConfiguration);
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public CreateLocationHdfsRequest withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public CreateLocationHdfsRequest withAuthenticationType(HdfsAuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setSimpleUser(String simpleUser) {
        this.simpleUser = simpleUser;
    }

    public String getSimpleUser() {
        return this.simpleUser;
    }

    public CreateLocationHdfsRequest withSimpleUser(String simpleUser) {
        this.setSimpleUser(simpleUser);
        return this;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public CreateLocationHdfsRequest withKerberosPrincipal(String kerberosPrincipal) {
        this.setKerberosPrincipal(kerberosPrincipal);
        return this;
    }

    public void setKerberosKeytab(ByteBuffer kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
    }

    public ByteBuffer getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    public CreateLocationHdfsRequest withKerberosKeytab(ByteBuffer kerberosKeytab) {
        this.setKerberosKeytab(kerberosKeytab);
        return this;
    }

    public void setKerberosKrb5Conf(ByteBuffer kerberosKrb5Conf) {
        this.kerberosKrb5Conf = kerberosKrb5Conf;
    }

    public ByteBuffer getKerberosKrb5Conf() {
        return this.kerberosKrb5Conf;
    }

    public CreateLocationHdfsRequest withKerberosKrb5Conf(ByteBuffer kerberosKrb5Conf) {
        this.setKerberosKrb5Conf(kerberosKrb5Conf);
        return this;
    }

    public List<String> getAgentArns() {
        return this.agentArns;
    }

    public void setAgentArns(Collection<String> agentArns) {
        if (agentArns == null) {
            this.agentArns = null;
            return;
        }
        this.agentArns = new ArrayList<String>(agentArns);
    }

    public CreateLocationHdfsRequest withAgentArns(String ... agentArns) {
        if (this.agentArns == null) {
            this.setAgentArns(new ArrayList<String>(agentArns.length));
        }
        for (String ele : agentArns) {
            this.agentArns.add(ele);
        }
        return this;
    }

    public CreateLocationHdfsRequest withAgentArns(Collection<String> agentArns) {
        this.setAgentArns(agentArns);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationHdfsRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationHdfsRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getNameNodes() != null) {
            sb.append("NameNodes: ").append(this.getNameNodes()).append(",");
        }
        if (this.getBlockSize() != null) {
            sb.append("BlockSize: ").append(this.getBlockSize()).append(",");
        }
        if (this.getReplicationFactor() != null) {
            sb.append("ReplicationFactor: ").append(this.getReplicationFactor()).append(",");
        }
        if (this.getKmsKeyProviderUri() != null) {
            sb.append("KmsKeyProviderUri: ").append(this.getKmsKeyProviderUri()).append(",");
        }
        if (this.getQopConfiguration() != null) {
            sb.append("QopConfiguration: ").append(this.getQopConfiguration()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getSimpleUser() != null) {
            sb.append("SimpleUser: ").append(this.getSimpleUser()).append(",");
        }
        if (this.getKerberosPrincipal() != null) {
            sb.append("KerberosPrincipal: ").append(this.getKerberosPrincipal()).append(",");
        }
        if (this.getKerberosKeytab() != null) {
            sb.append("KerberosKeytab: ").append(this.getKerberosKeytab()).append(",");
        }
        if (this.getKerberosKrb5Conf() != null) {
            sb.append("KerberosKrb5Conf: ").append(this.getKerberosKrb5Conf()).append(",");
        }
        if (this.getAgentArns() != null) {
            sb.append("AgentArns: ").append(this.getAgentArns()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationHdfsRequest)) {
            return false;
        }
        CreateLocationHdfsRequest other = (CreateLocationHdfsRequest)obj;
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getNameNodes() == null ^ this.getNameNodes() == null) {
            return false;
        }
        if (other.getNameNodes() != null && !other.getNameNodes().equals(this.getNameNodes())) {
            return false;
        }
        if (other.getBlockSize() == null ^ this.getBlockSize() == null) {
            return false;
        }
        if (other.getBlockSize() != null && !other.getBlockSize().equals(this.getBlockSize())) {
            return false;
        }
        if (other.getReplicationFactor() == null ^ this.getReplicationFactor() == null) {
            return false;
        }
        if (other.getReplicationFactor() != null && !other.getReplicationFactor().equals(this.getReplicationFactor())) {
            return false;
        }
        if (other.getKmsKeyProviderUri() == null ^ this.getKmsKeyProviderUri() == null) {
            return false;
        }
        if (other.getKmsKeyProviderUri() != null && !other.getKmsKeyProviderUri().equals(this.getKmsKeyProviderUri())) {
            return false;
        }
        if (other.getQopConfiguration() == null ^ this.getQopConfiguration() == null) {
            return false;
        }
        if (other.getQopConfiguration() != null && !other.getQopConfiguration().equals(this.getQopConfiguration())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getSimpleUser() == null ^ this.getSimpleUser() == null) {
            return false;
        }
        if (other.getSimpleUser() != null && !other.getSimpleUser().equals(this.getSimpleUser())) {
            return false;
        }
        if (other.getKerberosPrincipal() == null ^ this.getKerberosPrincipal() == null) {
            return false;
        }
        if (other.getKerberosPrincipal() != null && !other.getKerberosPrincipal().equals(this.getKerberosPrincipal())) {
            return false;
        }
        if (other.getKerberosKeytab() == null ^ this.getKerberosKeytab() == null) {
            return false;
        }
        if (other.getKerberosKeytab() != null && !other.getKerberosKeytab().equals(this.getKerberosKeytab())) {
            return false;
        }
        if (other.getKerberosKrb5Conf() == null ^ this.getKerberosKrb5Conf() == null) {
            return false;
        }
        if (other.getKerberosKrb5Conf() != null && !other.getKerberosKrb5Conf().equals(this.getKerberosKrb5Conf())) {
            return false;
        }
        if (other.getAgentArns() == null ^ this.getAgentArns() == null) {
            return false;
        }
        if (other.getAgentArns() != null && !other.getAgentArns().equals(this.getAgentArns())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getNameNodes() == null ? 0 : this.getNameNodes().hashCode());
        hashCode = 31 * hashCode + (this.getBlockSize() == null ? 0 : this.getBlockSize().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationFactor() == null ? 0 : this.getReplicationFactor().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyProviderUri() == null ? 0 : this.getKmsKeyProviderUri().hashCode());
        hashCode = 31 * hashCode + (this.getQopConfiguration() == null ? 0 : this.getQopConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getSimpleUser() == null ? 0 : this.getSimpleUser().hashCode());
        hashCode = 31 * hashCode + (this.getKerberosPrincipal() == null ? 0 : this.getKerberosPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getKerberosKeytab() == null ? 0 : this.getKerberosKeytab().hashCode());
        hashCode = 31 * hashCode + (this.getKerberosKrb5Conf() == null ? 0 : this.getKerberosKrb5Conf().hashCode());
        hashCode = 31 * hashCode + (this.getAgentArns() == null ? 0 : this.getAgentArns().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLocationHdfsRequest clone() {
        return (CreateLocationHdfsRequest)super.clone();
    }
}

