/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.RecommendationRelatedAnomaly;
import com.amazonaws.services.devopsguru.model.RecommendationRelatedEvent;
import com.amazonaws.services.devopsguru.model.transform.RecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Recommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private String link;
    private String name;
    private String reason;
    private List<RecommendationRelatedEvent> relatedEvents;
    private List<RecommendationRelatedAnomaly> relatedAnomalies;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Recommendation withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public Recommendation withLink(String link) {
        this.setLink(link);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Recommendation withName(String name) {
        this.setName(name);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public Recommendation withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public List<RecommendationRelatedEvent> getRelatedEvents() {
        return this.relatedEvents;
    }

    public void setRelatedEvents(Collection<RecommendationRelatedEvent> relatedEvents) {
        if (relatedEvents == null) {
            this.relatedEvents = null;
            return;
        }
        this.relatedEvents = new ArrayList<RecommendationRelatedEvent>(relatedEvents);
    }

    public Recommendation withRelatedEvents(RecommendationRelatedEvent ... relatedEvents) {
        if (this.relatedEvents == null) {
            this.setRelatedEvents(new ArrayList<RecommendationRelatedEvent>(relatedEvents.length));
        }
        for (RecommendationRelatedEvent ele : relatedEvents) {
            this.relatedEvents.add(ele);
        }
        return this;
    }

    public Recommendation withRelatedEvents(Collection<RecommendationRelatedEvent> relatedEvents) {
        this.setRelatedEvents(relatedEvents);
        return this;
    }

    public List<RecommendationRelatedAnomaly> getRelatedAnomalies() {
        return this.relatedAnomalies;
    }

    public void setRelatedAnomalies(Collection<RecommendationRelatedAnomaly> relatedAnomalies) {
        if (relatedAnomalies == null) {
            this.relatedAnomalies = null;
            return;
        }
        this.relatedAnomalies = new ArrayList<RecommendationRelatedAnomaly>(relatedAnomalies);
    }

    public Recommendation withRelatedAnomalies(RecommendationRelatedAnomaly ... relatedAnomalies) {
        if (this.relatedAnomalies == null) {
            this.setRelatedAnomalies(new ArrayList<RecommendationRelatedAnomaly>(relatedAnomalies.length));
        }
        for (RecommendationRelatedAnomaly ele : relatedAnomalies) {
            this.relatedAnomalies.add(ele);
        }
        return this;
    }

    public Recommendation withRelatedAnomalies(Collection<RecommendationRelatedAnomaly> relatedAnomalies) {
        this.setRelatedAnomalies(relatedAnomalies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLink() != null) {
            sb.append("Link: ").append(this.getLink()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason()).append(",");
        }
        if (this.getRelatedEvents() != null) {
            sb.append("RelatedEvents: ").append(this.getRelatedEvents()).append(",");
        }
        if (this.getRelatedAnomalies() != null) {
            sb.append("RelatedAnomalies: ").append(this.getRelatedAnomalies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLink() == null ^ this.getLink() == null) {
            return false;
        }
        if (other.getLink() != null && !other.getLink().equals(this.getLink())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getRelatedEvents() == null ^ this.getRelatedEvents() == null) {
            return false;
        }
        if (other.getRelatedEvents() != null && !other.getRelatedEvents().equals(this.getRelatedEvents())) {
            return false;
        }
        if (other.getRelatedAnomalies() == null ^ this.getRelatedAnomalies() == null) {
            return false;
        }
        return other.getRelatedAnomalies() == null || other.getRelatedAnomalies().equals(this.getRelatedAnomalies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLink() == null ? 0 : this.getLink().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedEvents() == null ? 0 : this.getRelatedEvents().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedAnomalies() == null ? 0 : this.getRelatedAnomalies().hashCode());
        return hashCode;
    }

    public Recommendation clone() {
        try {
            return (Recommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

