/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.AgentInfo;
import com.amazonaws.services.applicationdiscovery.model.AgentNetworkInfo;
import com.amazonaws.services.applicationdiscovery.model.transform.AgentNetworkInfoJsonMarshaller;
import java.util.List;

public class AgentInfoJsonMarshaller {
    private static AgentInfoJsonMarshaller instance;

    public void marshall(AgentInfo agentInfo, StructuredJsonGenerator jsonGenerator) {
        if (agentInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AgentNetworkInfo> agentNetworkInfoListList;
            jsonGenerator.writeStartObject();
            if (agentInfo.getAgentId() != null) {
                jsonGenerator.writeFieldName("agentId").writeValue(agentInfo.getAgentId());
            }
            if (agentInfo.getHostName() != null) {
                jsonGenerator.writeFieldName("hostName").writeValue(agentInfo.getHostName());
            }
            if ((agentNetworkInfoListList = agentInfo.getAgentNetworkInfoList()) != null) {
                jsonGenerator.writeFieldName("agentNetworkInfoList");
                jsonGenerator.writeStartArray();
                for (AgentNetworkInfo agentNetworkInfoListListValue : agentNetworkInfoListList) {
                    if (agentNetworkInfoListListValue == null) continue;
                    AgentNetworkInfoJsonMarshaller.getInstance().marshall(agentNetworkInfoListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (agentInfo.getConnectorId() != null) {
                jsonGenerator.writeFieldName("connectorId").writeValue(agentInfo.getConnectorId());
            }
            if (agentInfo.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(agentInfo.getVersion());
            }
            if (agentInfo.getHealth() != null) {
                jsonGenerator.writeFieldName("health").writeValue(agentInfo.getHealth());
            }
            if (agentInfo.getLastHealthPingTime() != null) {
                jsonGenerator.writeFieldName("lastHealthPingTime").writeValue(agentInfo.getLastHealthPingTime());
            }
            if (agentInfo.getCollectionStatus() != null) {
                jsonGenerator.writeFieldName("collectionStatus").writeValue(agentInfo.getCollectionStatus());
            }
            if (agentInfo.getAgentType() != null) {
                jsonGenerator.writeFieldName("agentType").writeValue(agentInfo.getAgentType());
            }
            if (agentInfo.getRegisteredTime() != null) {
                jsonGenerator.writeFieldName("registeredTime").writeValue(agentInfo.getRegisteredTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentInfoJsonMarshaller();
        }
        return instance;
    }
}

