/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.CreateGlobalClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateGlobalClusterRequestMarshaller
implements Marshaller<Request<CreateGlobalClusterRequest>, CreateGlobalClusterRequest> {
    public Request<CreateGlobalClusterRequest> marshall(CreateGlobalClusterRequest createGlobalClusterRequest) {
        if (createGlobalClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGlobalClusterRequest, "AmazonDocDB");
        request.addParameter("Action", "CreateGlobalCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createGlobalClusterRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString((String)createGlobalClusterRequest.getGlobalClusterIdentifier()));
        }
        if (createGlobalClusterRequest.getSourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString((String)createGlobalClusterRequest.getSourceDBClusterIdentifier()));
        }
        if (createGlobalClusterRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createGlobalClusterRequest.getEngine()));
        }
        if (createGlobalClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createGlobalClusterRequest.getEngineVersion()));
        }
        if (createGlobalClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)createGlobalClusterRequest.getDeletionProtection()));
        }
        if (createGlobalClusterRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)createGlobalClusterRequest.getDatabaseName()));
        }
        if (createGlobalClusterRequest.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createGlobalClusterRequest.getStorageEncrypted()));
        }
        return request;
    }
}

