/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.docdb.AmazonDocDBAsync;
import com.amazonaws.services.docdb.AmazonDocDBAsyncClientBuilder;
import com.amazonaws.services.docdb.AmazonDocDBClient;
import com.amazonaws.services.docdb.model.AddSourceIdentifierToSubscriptionRequest;
import com.amazonaws.services.docdb.model.AddTagsToResourceRequest;
import com.amazonaws.services.docdb.model.AddTagsToResourceResult;
import com.amazonaws.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import com.amazonaws.services.docdb.model.CopyDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.CopyDBClusterSnapshotRequest;
import com.amazonaws.services.docdb.model.CreateDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.CreateDBClusterRequest;
import com.amazonaws.services.docdb.model.CreateDBClusterSnapshotRequest;
import com.amazonaws.services.docdb.model.CreateDBInstanceRequest;
import com.amazonaws.services.docdb.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.docdb.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.docdb.model.CreateGlobalClusterRequest;
import com.amazonaws.services.docdb.model.DBCluster;
import com.amazonaws.services.docdb.model.DBClusterParameterGroup;
import com.amazonaws.services.docdb.model.DBClusterSnapshot;
import com.amazonaws.services.docdb.model.DBClusterSnapshotAttributesResult;
import com.amazonaws.services.docdb.model.DBInstance;
import com.amazonaws.services.docdb.model.DBSubnetGroup;
import com.amazonaws.services.docdb.model.DeleteDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.DeleteDBClusterParameterGroupResult;
import com.amazonaws.services.docdb.model.DeleteDBClusterRequest;
import com.amazonaws.services.docdb.model.DeleteDBClusterSnapshotRequest;
import com.amazonaws.services.docdb.model.DeleteDBInstanceRequest;
import com.amazonaws.services.docdb.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.docdb.model.DeleteDBSubnetGroupResult;
import com.amazonaws.services.docdb.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.docdb.model.DeleteGlobalClusterRequest;
import com.amazonaws.services.docdb.model.DescribeCertificatesRequest;
import com.amazonaws.services.docdb.model.DescribeCertificatesResult;
import com.amazonaws.services.docdb.model.DescribeDBClusterParameterGroupsRequest;
import com.amazonaws.services.docdb.model.DescribeDBClusterParameterGroupsResult;
import com.amazonaws.services.docdb.model.DescribeDBClusterParametersRequest;
import com.amazonaws.services.docdb.model.DescribeDBClusterParametersResult;
import com.amazonaws.services.docdb.model.DescribeDBClusterSnapshotAttributesRequest;
import com.amazonaws.services.docdb.model.DescribeDBClusterSnapshotsRequest;
import com.amazonaws.services.docdb.model.DescribeDBClusterSnapshotsResult;
import com.amazonaws.services.docdb.model.DescribeDBClustersRequest;
import com.amazonaws.services.docdb.model.DescribeDBClustersResult;
import com.amazonaws.services.docdb.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.docdb.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.docdb.model.DescribeDBInstancesRequest;
import com.amazonaws.services.docdb.model.DescribeDBInstancesResult;
import com.amazonaws.services.docdb.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.docdb.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import com.amazonaws.services.docdb.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.docdb.model.DescribeEventCategoriesResult;
import com.amazonaws.services.docdb.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.docdb.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.docdb.model.DescribeEventsRequest;
import com.amazonaws.services.docdb.model.DescribeEventsResult;
import com.amazonaws.services.docdb.model.DescribeGlobalClustersRequest;
import com.amazonaws.services.docdb.model.DescribeGlobalClustersResult;
import com.amazonaws.services.docdb.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.docdb.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import com.amazonaws.services.docdb.model.DescribePendingMaintenanceActionsResult;
import com.amazonaws.services.docdb.model.EngineDefaults;
import com.amazonaws.services.docdb.model.EventSubscription;
import com.amazonaws.services.docdb.model.FailoverDBClusterRequest;
import com.amazonaws.services.docdb.model.GlobalCluster;
import com.amazonaws.services.docdb.model.ListTagsForResourceRequest;
import com.amazonaws.services.docdb.model.ListTagsForResourceResult;
import com.amazonaws.services.docdb.model.ModifyDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.ModifyDBClusterParameterGroupResult;
import com.amazonaws.services.docdb.model.ModifyDBClusterRequest;
import com.amazonaws.services.docdb.model.ModifyDBClusterSnapshotAttributeRequest;
import com.amazonaws.services.docdb.model.ModifyDBInstanceRequest;
import com.amazonaws.services.docdb.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.docdb.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.docdb.model.ModifyGlobalClusterRequest;
import com.amazonaws.services.docdb.model.RebootDBInstanceRequest;
import com.amazonaws.services.docdb.model.RemoveFromGlobalClusterRequest;
import com.amazonaws.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest;
import com.amazonaws.services.docdb.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.docdb.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.docdb.model.ResetDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.ResetDBClusterParameterGroupResult;
import com.amazonaws.services.docdb.model.ResourcePendingMaintenanceActions;
import com.amazonaws.services.docdb.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.docdb.model.RestoreDBClusterToPointInTimeRequest;
import com.amazonaws.services.docdb.model.StartDBClusterRequest;
import com.amazonaws.services.docdb.model.StopDBClusterRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDocDBAsyncClient
extends AmazonDocDBClient
implements AmazonDocDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDocDBAsyncClientBuilder asyncBuilder() {
        return AmazonDocDBAsyncClientBuilder.standard();
    }

    AmazonDocDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDocDBAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(AddSourceIdentifierToSubscriptionRequest request) {
        return this.addSourceIdentifierToSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(AddSourceIdentifierToSubscriptionRequest request, final AsyncHandler<AddSourceIdentifierToSubscriptionRequest, EventSubscription> asyncHandler) {
        final AddSourceIdentifierToSubscriptionRequest finalRequest = (AddSourceIdentifierToSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeAddSourceIdentifierToSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        final AddTagsToResourceRequest finalRequest = (AddTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeAddTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(ApplyPendingMaintenanceActionRequest request) {
        return this.applyPendingMaintenanceActionAsync(request, null);
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(ApplyPendingMaintenanceActionRequest request, final AsyncHandler<ApplyPendingMaintenanceActionRequest, ResourcePendingMaintenanceActions> asyncHandler) {
        final ApplyPendingMaintenanceActionRequest finalRequest = (ApplyPendingMaintenanceActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResourcePendingMaintenanceActions>(){

            @Override
            public ResourcePendingMaintenanceActions call() throws Exception {
                ResourcePendingMaintenanceActions result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeApplyPendingMaintenanceAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(CopyDBClusterParameterGroupRequest request) {
        return this.copyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(CopyDBClusterParameterGroupRequest request, final AsyncHandler<CopyDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        final CopyDBClusterParameterGroupRequest finalRequest = (CopyDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCopyDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(CopyDBClusterSnapshotRequest request) {
        return this.copyDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(CopyDBClusterSnapshotRequest request, final AsyncHandler<CopyDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final CopyDBClusterSnapshotRequest finalRequest = (CopyDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCopyDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(CreateDBClusterRequest request) {
        return this.createDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(CreateDBClusterRequest request, final AsyncHandler<CreateDBClusterRequest, DBCluster> asyncHandler) {
        final CreateDBClusterRequest finalRequest = (CreateDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(CreateDBClusterParameterGroupRequest request) {
        return this.createDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(CreateDBClusterParameterGroupRequest request, final AsyncHandler<CreateDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        final CreateDBClusterParameterGroupRequest finalRequest = (CreateDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(CreateDBClusterSnapshotRequest request) {
        return this.createDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(CreateDBClusterSnapshotRequest request, final AsyncHandler<CreateDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final CreateDBClusterSnapshotRequest finalRequest = (CreateDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(CreateDBInstanceRequest request) {
        return this.createDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(CreateDBInstanceRequest request, final AsyncHandler<CreateDBInstanceRequest, DBInstance> asyncHandler) {
        final CreateDBInstanceRequest finalRequest = (CreateDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(CreateDBSubnetGroupRequest request) {
        return this.createDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(CreateDBSubnetGroupRequest request, final AsyncHandler<CreateDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        final CreateDBSubnetGroupRequest finalRequest = (CreateDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request) {
        return this.createEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final CreateEventSubscriptionRequest finalRequest = (CreateEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GlobalCluster> createGlobalClusterAsync(CreateGlobalClusterRequest request) {
        return this.createGlobalClusterAsync(request, null);
    }

    @Override
    public Future<GlobalCluster> createGlobalClusterAsync(CreateGlobalClusterRequest request, final AsyncHandler<CreateGlobalClusterRequest, GlobalCluster> asyncHandler) {
        final CreateGlobalClusterRequest finalRequest = (CreateGlobalClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GlobalCluster>(){

            @Override
            public GlobalCluster call() throws Exception {
                GlobalCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeCreateGlobalCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(DeleteDBClusterRequest request) {
        return this.deleteDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(DeleteDBClusterRequest request, final AsyncHandler<DeleteDBClusterRequest, DBCluster> asyncHandler) {
        final DeleteDBClusterRequest finalRequest = (DeleteDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(DeleteDBClusterParameterGroupRequest request) {
        return this.deleteDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(DeleteDBClusterParameterGroupRequest request, final AsyncHandler<DeleteDBClusterParameterGroupRequest, DeleteDBClusterParameterGroupResult> asyncHandler) {
        final DeleteDBClusterParameterGroupRequest finalRequest = (DeleteDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDBClusterParameterGroupResult>(){

            @Override
            public DeleteDBClusterParameterGroupResult call() throws Exception {
                DeleteDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(DeleteDBClusterSnapshotRequest request) {
        return this.deleteDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(DeleteDBClusterSnapshotRequest request, final AsyncHandler<DeleteDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        final DeleteDBClusterSnapshotRequest finalRequest = (DeleteDBClusterSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteDBClusterSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(DeleteDBInstanceRequest request) {
        return this.deleteDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(DeleteDBInstanceRequest request, final AsyncHandler<DeleteDBInstanceRequest, DBInstance> asyncHandler) {
        final DeleteDBInstanceRequest finalRequest = (DeleteDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(DeleteDBSubnetGroupRequest request) {
        return this.deleteDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(DeleteDBSubnetGroupRequest request, final AsyncHandler<DeleteDBSubnetGroupRequest, DeleteDBSubnetGroupResult> asyncHandler) {
        final DeleteDBSubnetGroupRequest finalRequest = (DeleteDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDBSubnetGroupResult>(){

            @Override
            public DeleteDBSubnetGroupResult call() throws Exception {
                DeleteDBSubnetGroupResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request) {
        return this.deleteEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request, final AsyncHandler<DeleteEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final DeleteEventSubscriptionRequest finalRequest = (DeleteEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GlobalCluster> deleteGlobalClusterAsync(DeleteGlobalClusterRequest request) {
        return this.deleteGlobalClusterAsync(request, null);
    }

    @Override
    public Future<GlobalCluster> deleteGlobalClusterAsync(DeleteGlobalClusterRequest request, final AsyncHandler<DeleteGlobalClusterRequest, GlobalCluster> asyncHandler) {
        final DeleteGlobalClusterRequest finalRequest = (DeleteGlobalClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GlobalCluster>(){

            @Override
            public GlobalCluster call() throws Exception {
                GlobalCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDeleteGlobalCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(DescribeCertificatesRequest request) {
        return this.describeCertificatesAsync(request, null);
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(DescribeCertificatesRequest request, final AsyncHandler<DescribeCertificatesRequest, DescribeCertificatesResult> asyncHandler) {
        final DescribeCertificatesRequest finalRequest = (DescribeCertificatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCertificatesResult>(){

            @Override
            public DescribeCertificatesResult call() throws Exception {
                DescribeCertificatesResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeCertificates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(DescribeDBClusterParameterGroupsRequest request) {
        return this.describeDBClusterParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(DescribeDBClusterParameterGroupsRequest request, final AsyncHandler<DescribeDBClusterParameterGroupsRequest, DescribeDBClusterParameterGroupsResult> asyncHandler) {
        final DescribeDBClusterParameterGroupsRequest finalRequest = (DescribeDBClusterParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterParameterGroupsResult>(){

            @Override
            public DescribeDBClusterParameterGroupsResult call() throws Exception {
                DescribeDBClusterParameterGroupsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBClusterParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(DescribeDBClusterParametersRequest request) {
        return this.describeDBClusterParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(DescribeDBClusterParametersRequest request, final AsyncHandler<DescribeDBClusterParametersRequest, DescribeDBClusterParametersResult> asyncHandler) {
        final DescribeDBClusterParametersRequest finalRequest = (DescribeDBClusterParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterParametersResult>(){

            @Override
            public DescribeDBClusterParametersResult call() throws Exception {
                DescribeDBClusterParametersResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBClusterParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(DescribeDBClusterSnapshotAttributesRequest request) {
        return this.describeDBClusterSnapshotAttributesAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(DescribeDBClusterSnapshotAttributesRequest request, final AsyncHandler<DescribeDBClusterSnapshotAttributesRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        final DescribeDBClusterSnapshotAttributesRequest finalRequest = (DescribeDBClusterSnapshotAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBClusterSnapshotAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(DescribeDBClusterSnapshotsRequest request) {
        return this.describeDBClusterSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(DescribeDBClusterSnapshotsRequest request, final AsyncHandler<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult> asyncHandler) {
        final DescribeDBClusterSnapshotsRequest finalRequest = (DescribeDBClusterSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClusterSnapshotsResult>(){

            @Override
            public DescribeDBClusterSnapshotsResult call() throws Exception {
                DescribeDBClusterSnapshotsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBClusterSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(DescribeDBClustersRequest request) {
        return this.describeDBClustersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(DescribeDBClustersRequest request, final AsyncHandler<DescribeDBClustersRequest, DescribeDBClustersResult> asyncHandler) {
        final DescribeDBClustersRequest finalRequest = (DescribeDBClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBClustersResult>(){

            @Override
            public DescribeDBClustersResult call() throws Exception {
                DescribeDBClustersResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(DescribeDBEngineVersionsRequest request) {
        return this.describeDBEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(DescribeDBEngineVersionsRequest request, final AsyncHandler<DescribeDBEngineVersionsRequest, DescribeDBEngineVersionsResult> asyncHandler) {
        final DescribeDBEngineVersionsRequest finalRequest = (DescribeDBEngineVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                DescribeDBEngineVersionsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBEngineVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(DescribeDBInstancesRequest request) {
        return this.describeDBInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(DescribeDBInstancesRequest request, final AsyncHandler<DescribeDBInstancesRequest, DescribeDBInstancesResult> asyncHandler) {
        final DescribeDBInstancesRequest finalRequest = (DescribeDBInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                DescribeDBInstancesResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(DescribeDBSubnetGroupsRequest request) {
        return this.describeDBSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(DescribeDBSubnetGroupsRequest request, final AsyncHandler<DescribeDBSubnetGroupsRequest, DescribeDBSubnetGroupsResult> asyncHandler) {
        final DescribeDBSubnetGroupsRequest finalRequest = (DescribeDBSubnetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                DescribeDBSubnetGroupsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeDBSubnetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(DescribeEngineDefaultClusterParametersRequest request) {
        return this.describeEngineDefaultClusterParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(DescribeEngineDefaultClusterParametersRequest request, final AsyncHandler<DescribeEngineDefaultClusterParametersRequest, EngineDefaults> asyncHandler) {
        final DescribeEngineDefaultClusterParametersRequest finalRequest = (DescribeEngineDefaultClusterParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeEngineDefaultClusterParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request) {
        return this.describeEventCategoriesAsync(request, null);
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        final DescribeEventCategoriesRequest finalRequest = (DescribeEventCategoriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeEventCategories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request) {
        return this.describeEventSubscriptionsAsync(request, null);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        final DescribeEventSubscriptionsRequest finalRequest = (DescribeEventSubscriptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeEventSubscriptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalClustersResult> describeGlobalClustersAsync(DescribeGlobalClustersRequest request) {
        return this.describeGlobalClustersAsync(request, null);
    }

    @Override
    public Future<DescribeGlobalClustersResult> describeGlobalClustersAsync(DescribeGlobalClustersRequest request, final AsyncHandler<DescribeGlobalClustersRequest, DescribeGlobalClustersResult> asyncHandler) {
        final DescribeGlobalClustersRequest finalRequest = (DescribeGlobalClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGlobalClustersResult>(){

            @Override
            public DescribeGlobalClustersResult call() throws Exception {
                DescribeGlobalClustersResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeGlobalClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(DescribeOrderableDBInstanceOptionsRequest request) {
        return this.describeOrderableDBInstanceOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(DescribeOrderableDBInstanceOptionsRequest request, final AsyncHandler<DescribeOrderableDBInstanceOptionsRequest, DescribeOrderableDBInstanceOptionsResult> asyncHandler) {
        final DescribeOrderableDBInstanceOptionsRequest finalRequest = (DescribeOrderableDBInstanceOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                DescribeOrderableDBInstanceOptionsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribeOrderableDBInstanceOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(DescribePendingMaintenanceActionsRequest request) {
        return this.describePendingMaintenanceActionsAsync(request, null);
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(DescribePendingMaintenanceActionsRequest request, final AsyncHandler<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResult> asyncHandler) {
        final DescribePendingMaintenanceActionsRequest finalRequest = (DescribePendingMaintenanceActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePendingMaintenanceActionsResult>(){

            @Override
            public DescribePendingMaintenanceActionsResult call() throws Exception {
                DescribePendingMaintenanceActionsResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeDescribePendingMaintenanceActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(FailoverDBClusterRequest request) {
        return this.failoverDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(FailoverDBClusterRequest request, final AsyncHandler<FailoverDBClusterRequest, DBCluster> asyncHandler) {
        final FailoverDBClusterRequest finalRequest = (FailoverDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeFailoverDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(ModifyDBClusterRequest request) {
        return this.modifyDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(ModifyDBClusterRequest request, final AsyncHandler<ModifyDBClusterRequest, DBCluster> asyncHandler) {
        final ModifyDBClusterRequest finalRequest = (ModifyDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(ModifyDBClusterParameterGroupRequest request) {
        return this.modifyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(ModifyDBClusterParameterGroupRequest request, final AsyncHandler<ModifyDBClusterParameterGroupRequest, ModifyDBClusterParameterGroupResult> asyncHandler) {
        final ModifyDBClusterParameterGroupRequest finalRequest = (ModifyDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyDBClusterParameterGroupResult>(){

            @Override
            public ModifyDBClusterParameterGroupResult call() throws Exception {
                ModifyDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(ModifyDBClusterSnapshotAttributeRequest request) {
        return this.modifyDBClusterSnapshotAttributeAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(ModifyDBClusterSnapshotAttributeRequest request, final AsyncHandler<ModifyDBClusterSnapshotAttributeRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        final ModifyDBClusterSnapshotAttributeRequest finalRequest = (ModifyDBClusterSnapshotAttributeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyDBClusterSnapshotAttribute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(ModifyDBInstanceRequest request) {
        return this.modifyDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(ModifyDBInstanceRequest request, final AsyncHandler<ModifyDBInstanceRequest, DBInstance> asyncHandler) {
        final ModifyDBInstanceRequest finalRequest = (ModifyDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(ModifyDBSubnetGroupRequest request) {
        return this.modifyDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(ModifyDBSubnetGroupRequest request, final AsyncHandler<ModifyDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        final ModifyDBSubnetGroupRequest finalRequest = (ModifyDBSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyDBSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request) {
        return this.modifyEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) {
        final ModifyEventSubscriptionRequest finalRequest = (ModifyEventSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyEventSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GlobalCluster> modifyGlobalClusterAsync(ModifyGlobalClusterRequest request) {
        return this.modifyGlobalClusterAsync(request, null);
    }

    @Override
    public Future<GlobalCluster> modifyGlobalClusterAsync(ModifyGlobalClusterRequest request, final AsyncHandler<ModifyGlobalClusterRequest, GlobalCluster> asyncHandler) {
        final ModifyGlobalClusterRequest finalRequest = (ModifyGlobalClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GlobalCluster>(){

            @Override
            public GlobalCluster call() throws Exception {
                GlobalCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeModifyGlobalCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(RebootDBInstanceRequest request) {
        return this.rebootDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(RebootDBInstanceRequest request, final AsyncHandler<RebootDBInstanceRequest, DBInstance> asyncHandler) {
        final RebootDBInstanceRequest finalRequest = (RebootDBInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRebootDBInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GlobalCluster> removeFromGlobalClusterAsync(RemoveFromGlobalClusterRequest request) {
        return this.removeFromGlobalClusterAsync(request, null);
    }

    @Override
    public Future<GlobalCluster> removeFromGlobalClusterAsync(RemoveFromGlobalClusterRequest request, final AsyncHandler<RemoveFromGlobalClusterRequest, GlobalCluster> asyncHandler) {
        final RemoveFromGlobalClusterRequest finalRequest = (RemoveFromGlobalClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GlobalCluster>(){

            @Override
            public GlobalCluster call() throws Exception {
                GlobalCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRemoveFromGlobalCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(RemoveSourceIdentifierFromSubscriptionRequest request) {
        return this.removeSourceIdentifierFromSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(RemoveSourceIdentifierFromSubscriptionRequest request, final AsyncHandler<RemoveSourceIdentifierFromSubscriptionRequest, EventSubscription> asyncHandler) {
        final RemoveSourceIdentifierFromSubscriptionRequest finalRequest = (RemoveSourceIdentifierFromSubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRemoveSourceIdentifierFromSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        final RemoveTagsFromResourceRequest finalRequest = (RemoveTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRemoveTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(ResetDBClusterParameterGroupRequest request) {
        return this.resetDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(ResetDBClusterParameterGroupRequest request, final AsyncHandler<ResetDBClusterParameterGroupRequest, ResetDBClusterParameterGroupResult> asyncHandler) {
        final ResetDBClusterParameterGroupRequest finalRequest = (ResetDBClusterParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetDBClusterParameterGroupResult>(){

            @Override
            public ResetDBClusterParameterGroupResult call() throws Exception {
                ResetDBClusterParameterGroupResult result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeResetDBClusterParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(RestoreDBClusterFromSnapshotRequest request) {
        return this.restoreDBClusterFromSnapshotAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(RestoreDBClusterFromSnapshotRequest request, final AsyncHandler<RestoreDBClusterFromSnapshotRequest, DBCluster> asyncHandler) {
        final RestoreDBClusterFromSnapshotRequest finalRequest = (RestoreDBClusterFromSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRestoreDBClusterFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(RestoreDBClusterToPointInTimeRequest request) {
        return this.restoreDBClusterToPointInTimeAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(RestoreDBClusterToPointInTimeRequest request, final AsyncHandler<RestoreDBClusterToPointInTimeRequest, DBCluster> asyncHandler) {
        final RestoreDBClusterToPointInTimeRequest finalRequest = (RestoreDBClusterToPointInTimeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeRestoreDBClusterToPointInTime(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> startDBClusterAsync(StartDBClusterRequest request) {
        return this.startDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> startDBClusterAsync(StartDBClusterRequest request, final AsyncHandler<StartDBClusterRequest, DBCluster> asyncHandler) {
        final StartDBClusterRequest finalRequest = (StartDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeStartDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> stopDBClusterAsync(StopDBClusterRequest request) {
        return this.stopDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> stopDBClusterAsync(StopDBClusterRequest request, final AsyncHandler<StopDBClusterRequest, DBCluster> asyncHandler) {
        final StopDBClusterRequest finalRequest = (StopDBClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result = null;
                try {
                    result = AmazonDocDBAsyncClient.this.executeStopDBCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

