/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.StreamDescription;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ShardJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    public void marshall(StreamDescription streamDescription, StructuredJsonGenerator jsonGenerator) {
        if (streamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Shard> shardsList;
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            if (streamDescription.getStreamArn() != null) {
                jsonGenerator.writeFieldName("StreamArn").writeValue(streamDescription.getStreamArn());
            }
            if (streamDescription.getStreamLabel() != null) {
                jsonGenerator.writeFieldName("StreamLabel").writeValue(streamDescription.getStreamLabel());
            }
            if (streamDescription.getStreamStatus() != null) {
                jsonGenerator.writeFieldName("StreamStatus").writeValue(streamDescription.getStreamStatus());
            }
            if (streamDescription.getStreamViewType() != null) {
                jsonGenerator.writeFieldName("StreamViewType").writeValue(streamDescription.getStreamViewType());
            }
            if (streamDescription.getCreationRequestDateTime() != null) {
                jsonGenerator.writeFieldName("CreationRequestDateTime").writeValue(streamDescription.getCreationRequestDateTime());
            }
            if (streamDescription.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(streamDescription.getTableName());
            }
            if ((keySchemaList = streamDescription.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((shardsList = streamDescription.getShards()) != null) {
                jsonGenerator.writeFieldName("Shards");
                jsonGenerator.writeStartArray();
                for (Shard shardsListValue : shardsList) {
                    if (shardsListValue == null) continue;
                    ShardJsonMarshaller.getInstance().marshall(shardsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (streamDescription.getLastEvaluatedShardId() != null) {
                jsonGenerator.writeFieldName("LastEvaluatedShardId").writeValue(streamDescription.getLastEvaluatedShardId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

