/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;

public interface DynamoDBMapperModelFactory {
    public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> var1);

    public static enum Schema {
        V1_0(ConversionSchemas.V1),
        V1_5(ConversionSchemas.V2_COMPATIBLE),
        V2_0(ConversionSchemas.V2);

        public static final Schema DEFAULT;
        private final ConversionSchema schema;

        private Schema(ConversionSchema schema) {
            this.schema = schema;
        }

        public boolean compatible(Schema schema) {
            return schema != null && schema.ordinal() >= this.ordinal();
        }

        public static Schema of(DynamoDBMapperConfig config) {
            for (Schema schema : Schema.values()) {
                if (schema.schema != config.getConversionSchema()) continue;
                return schema;
            }
            return null;
        }

        static {
            DEFAULT = V1_5;
        }
    }

    public static interface Factory {
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig var1);
    }
}

