/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.util.Map;

@SdkInternalApi
public class ConsumedCapacityMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Double> CAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").build();
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<Map> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").build();
    private static final MarshallingInfo<Map> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").build();
    private static final ConsumedCapacityMarshaller instance = new ConsumedCapacityMarshaller();

    public static ConsumedCapacityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConsumedCapacity consumedCapacity, ProtocolMarshaller protocolMarshaller) {
        if (consumedCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)consumedCapacity.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)consumedCapacity.getCapacityUnits(), CAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)consumedCapacity.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getLocalSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getGlobalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

