/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateTableRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTableRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.CreateTable");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GlobalSecondaryIndex> list;
            List<LocalSecondaryIndex> list2;
            List<KeySchemaElement> keySchemaList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<AttributeDefinition> attributeDefinitionsList = createTableRequest.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonGenerator.writeFieldName("AttributeDefinitions");
                jsonGenerator.writeStartArray();
                for (AttributeDefinition attributeDefinition : attributeDefinitionsList) {
                    if (attributeDefinition == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinition, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createTableRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(createTableRequest.getTableName());
            }
            if ((keySchemaList = createTableRequest.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaElement : keySchemaList) {
                    if (keySchemaElement == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaElement, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = createTableRequest.getLocalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("LocalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (LocalSecondaryIndex localSecondaryIndex : list2) {
                    if (localSecondaryIndex == null) continue;
                    LocalSecondaryIndexJsonMarshaller.getInstance().marshall(localSecondaryIndex, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = createTableRequest.getGlobalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("GlobalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (GlobalSecondaryIndex globalSecondaryIndexesListValue : list) {
                    if (globalSecondaryIndexesListValue == null) continue;
                    GlobalSecondaryIndexJsonMarshaller.getInstance().marshall(globalSecondaryIndexesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createTableRequest.getProvisionedThroughput() != null) {
                jsonGenerator.writeFieldName("ProvisionedThroughput");
                ProvisionedThroughputJsonMarshaller.getInstance().marshall(createTableRequest.getProvisionedThroughput(), jsonGenerator);
            }
            if (createTableRequest.getStreamSpecification() != null) {
                jsonGenerator.writeFieldName("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(createTableRequest.getStreamSpecification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

