/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ebs.model.Block;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListSnapshotBlocksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Block> blocks;
    private Date expiryTime;
    private Long volumeSize;
    private Integer blockSize;
    private String nextToken;

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Collection<Block> blocks) {
        if (blocks == null) {
            this.blocks = null;
            return;
        }
        this.blocks = new ArrayList<Block>(blocks);
    }

    public ListSnapshotBlocksResult withBlocks(Block ... blocks) {
        if (this.blocks == null) {
            this.setBlocks(new ArrayList<Block>(blocks.length));
        }
        for (Block ele : blocks) {
            this.blocks.add(ele);
        }
        return this;
    }

    public ListSnapshotBlocksResult withBlocks(Collection<Block> blocks) {
        this.setBlocks(blocks);
        return this;
    }

    public void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public ListSnapshotBlocksResult withExpiryTime(Date expiryTime) {
        this.setExpiryTime(expiryTime);
        return this;
    }

    public void setVolumeSize(Long volumeSize) {
        this.volumeSize = volumeSize;
    }

    public Long getVolumeSize() {
        return this.volumeSize;
    }

    public ListSnapshotBlocksResult withVolumeSize(Long volumeSize) {
        this.setVolumeSize(volumeSize);
        return this;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public ListSnapshotBlocksResult withBlockSize(Integer blockSize) {
        this.setBlockSize(blockSize);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSnapshotBlocksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlocks() != null) {
            sb.append("Blocks: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExpiryTime() != null) {
            sb.append("ExpiryTime: ").append(this.getExpiryTime()).append(",");
        }
        if (this.getVolumeSize() != null) {
            sb.append("VolumeSize: ").append(this.getVolumeSize()).append(",");
        }
        if (this.getBlockSize() != null) {
            sb.append("BlockSize: ").append(this.getBlockSize()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotBlocksResult)) {
            return false;
        }
        ListSnapshotBlocksResult other = (ListSnapshotBlocksResult)obj;
        if (other.getBlocks() == null ^ this.getBlocks() == null) {
            return false;
        }
        if (other.getBlocks() != null && !other.getBlocks().equals(this.getBlocks())) {
            return false;
        }
        if (other.getExpiryTime() == null ^ this.getExpiryTime() == null) {
            return false;
        }
        if (other.getExpiryTime() != null && !other.getExpiryTime().equals(this.getExpiryTime())) {
            return false;
        }
        if (other.getVolumeSize() == null ^ this.getVolumeSize() == null) {
            return false;
        }
        if (other.getVolumeSize() != null && !other.getVolumeSize().equals(this.getVolumeSize())) {
            return false;
        }
        if (other.getBlockSize() == null ^ this.getBlockSize() == null) {
            return false;
        }
        if (other.getBlockSize() != null && !other.getBlockSize().equals(this.getBlockSize())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlocks() == null ? 0 : this.getBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getExpiryTime() == null ? 0 : this.getExpiryTime().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSize() == null ? 0 : this.getVolumeSize().hashCode());
        hashCode = 31 * hashCode + (this.getBlockSize() == null ? 0 : this.getBlockSize().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSnapshotBlocksResult clone() {
        try {
            return (ListSnapshotBlocksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

