/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCountRequest;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.ec2.model.GetSpotPlacementScoresRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsWithMetadataRequest;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.ec2.model.MemoryMiBRequest;
import com.amazonaws.services.ec2.model.NetworkBandwidthGbpsRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.ec2.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.ec2.model.VCpuCountRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSpotPlacementScoresRequestMarshaller
implements Marshaller<Request<GetSpotPlacementScoresRequest>, GetSpotPlacementScoresRequest> {
    public Request<GetSpotPlacementScoresRequest> marshall(GetSpotPlacementScoresRequest getSpotPlacementScoresRequest) {
        InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;
        SdkInternalList getSpotPlacementScoresRequestRegionNamesList;
        if (getSpotPlacementScoresRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSpotPlacementScoresRequest, "AmazonEC2");
        request.addParameter("Action", "GetSpotPlacementScores");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList getSpotPlacementScoresRequestInstanceTypesList = (SdkInternalList)getSpotPlacementScoresRequest.getInstanceTypes();
        if (!getSpotPlacementScoresRequestInstanceTypesList.isEmpty() || !getSpotPlacementScoresRequestInstanceTypesList.isAutoConstruct()) {
            int instanceTypesListIndex = 1;
            for (Object getSpotPlacementScoresRequestInstanceTypesListValue : getSpotPlacementScoresRequestInstanceTypesList) {
                if (getSpotPlacementScoresRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString((String)getSpotPlacementScoresRequestInstanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (getSpotPlacementScoresRequest.getTargetCapacity() != null) {
            request.addParameter("TargetCapacity", StringUtils.fromInteger((Integer)getSpotPlacementScoresRequest.getTargetCapacity()));
        }
        if (getSpotPlacementScoresRequest.getTargetCapacityUnitType() != null) {
            request.addParameter("TargetCapacityUnitType", StringUtils.fromString((String)getSpotPlacementScoresRequest.getTargetCapacityUnitType()));
        }
        if (getSpotPlacementScoresRequest.getSingleAvailabilityZone() != null) {
            request.addParameter("SingleAvailabilityZone", StringUtils.fromBoolean((Boolean)getSpotPlacementScoresRequest.getSingleAvailabilityZone()));
        }
        if (!(getSpotPlacementScoresRequestRegionNamesList = (SdkInternalList)getSpotPlacementScoresRequest.getRegionNames()).isEmpty() || !getSpotPlacementScoresRequestRegionNamesList.isAutoConstruct()) {
            int regionNamesListIndex = 1;
            for (String getSpotPlacementScoresRequestRegionNamesListValue : getSpotPlacementScoresRequestRegionNamesList) {
                if (getSpotPlacementScoresRequestRegionNamesListValue != null) {
                    request.addParameter("RegionName." + regionNamesListIndex, StringUtils.fromString((String)getSpotPlacementScoresRequestRegionNamesListValue));
                }
                ++regionNamesListIndex;
            }
        }
        if ((instanceRequirementsWithMetadata = getSpotPlacementScoresRequest.getInstanceRequirementsWithMetadata()) != null) {
            InstanceRequirementsRequest instanceRequirements;
            SdkInternalList instanceRequirementsWithMetadataRequestVirtualizationTypesList;
            SdkInternalList instanceRequirementsWithMetadataRequestArchitectureTypesList = (SdkInternalList)instanceRequirementsWithMetadata.getArchitectureTypes();
            if (!instanceRequirementsWithMetadataRequestArchitectureTypesList.isEmpty() || !instanceRequirementsWithMetadataRequestArchitectureTypesList.isAutoConstruct()) {
                int architectureTypesListIndex = 1;
                for (Object instanceRequirementsWithMetadataRequestArchitectureTypesListValue : instanceRequirementsWithMetadataRequestArchitectureTypesList) {
                    if (instanceRequirementsWithMetadataRequestArchitectureTypesListValue != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.ArchitectureType." + architectureTypesListIndex, StringUtils.fromString((String)instanceRequirementsWithMetadataRequestArchitectureTypesListValue));
                    }
                    ++architectureTypesListIndex;
                }
            }
            if (!(instanceRequirementsWithMetadataRequestVirtualizationTypesList = (SdkInternalList)instanceRequirementsWithMetadata.getVirtualizationTypes()).isEmpty() || !instanceRequirementsWithMetadataRequestVirtualizationTypesList.isAutoConstruct()) {
                int virtualizationTypesListIndex = 1;
                for (String instanceRequirementsWithMetadataRequestVirtualizationTypesListValue : instanceRequirementsWithMetadataRequestVirtualizationTypesList) {
                    if (instanceRequirementsWithMetadataRequestVirtualizationTypesListValue != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.VirtualizationType." + virtualizationTypesListIndex, StringUtils.fromString((String)instanceRequirementsWithMetadataRequestVirtualizationTypesListValue));
                    }
                    ++virtualizationTypesListIndex;
                }
            }
            if ((instanceRequirements = instanceRequirementsWithMetadata.getInstanceRequirements()) != null) {
                SdkInternalList instanceRequirementsRequestAllowedInstanceTypesList;
                NetworkBandwidthGbpsRequest networkBandwidthGbps;
                AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                SdkInternalList instanceRequirementsRequestAcceleratorNamesList;
                SdkInternalList instanceRequirementsRequestAcceleratorManufacturersList;
                AcceleratorCountRequest acceleratorCount;
                SdkInternalList instanceRequirementsRequestAcceleratorTypesList;
                BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                TotalLocalStorageGBRequest totalLocalStorageGB;
                SdkInternalList instanceRequirementsRequestLocalStorageTypesList;
                NetworkInterfaceCountRequest networkInterfaceCount;
                SdkInternalList instanceRequirementsRequestInstanceGenerationsList;
                SdkInternalList instanceRequirementsRequestExcludedInstanceTypesList;
                MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                SdkInternalList instanceRequirementsRequestCpuManufacturersList;
                MemoryMiBRequest memoryMiB;
                VCpuCountRangeRequest vCpuCount = instanceRequirements.getVCpuCount();
                if (vCpuCount != null) {
                    if (vCpuCount.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                    }
                    if (vCpuCount.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                    }
                }
                if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                    if (memoryMiB.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                    }
                    if (memoryMiB.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsRequestCpuManufacturersList.isAutoConstruct()) {
                    int cpuManufacturersListIndex = 1;
                    for (String instanceRequirementsRequestCpuManufacturersListValue : instanceRequirementsRequestCpuManufacturersList) {
                        if (instanceRequirementsRequestCpuManufacturersListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.CpuManufacturer." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestCpuManufacturersListValue));
                        }
                        ++cpuManufacturersListIndex;
                    }
                }
                if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                    if (memoryGiBPerVCpu.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                    }
                    if (memoryGiBPerVCpu.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsRequestExcludedInstanceTypesList.isAutoConstruct()) {
                    int excludedInstanceTypesListIndex = 1;
                    for (Object instanceRequirementsRequestExcludedInstanceTypesListValue : instanceRequirementsRequestExcludedInstanceTypesList) {
                        if (instanceRequirementsRequestExcludedInstanceTypesListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.ExcludedInstanceType." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestExcludedInstanceTypesListValue));
                        }
                        ++excludedInstanceTypesListIndex;
                    }
                }
                if (!(instanceRequirementsRequestInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsRequestInstanceGenerationsList.isAutoConstruct()) {
                    int instanceGenerationsListIndex = 1;
                    for (String instanceRequirementsRequestInstanceGenerationsListValue : instanceRequirementsRequestInstanceGenerationsList) {
                        if (instanceRequirementsRequestInstanceGenerationsListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.InstanceGeneration." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsRequestInstanceGenerationsListValue));
                        }
                        ++instanceGenerationsListIndex;
                    }
                }
                if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (instanceRequirements.getBareMetal() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                }
                if (instanceRequirements.getBurstablePerformance() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                }
                if (instanceRequirements.getRequireHibernateSupport() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                }
                if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                    if (networkInterfaceCount.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                    }
                    if (networkInterfaceCount.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                    }
                }
                if (instanceRequirements.getLocalStorage() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                }
                if (!(instanceRequirementsRequestLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsRequestLocalStorageTypesList.isAutoConstruct()) {
                    int localStorageTypesListIndex = 1;
                    for (String instanceRequirementsRequestLocalStorageTypesListValue : instanceRequirementsRequestLocalStorageTypesList) {
                        if (instanceRequirementsRequestLocalStorageTypesListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.LocalStorageType." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestLocalStorageTypesListValue));
                        }
                        ++localStorageTypesListIndex;
                    }
                }
                if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                    if (totalLocalStorageGB.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                    }
                    if (totalLocalStorageGB.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                    }
                }
                if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                    if (baselineEbsBandwidthMbps.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                    }
                    if (baselineEbsBandwidthMbps.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsRequestAcceleratorTypesList.isAutoConstruct()) {
                    int acceleratorTypesListIndex = 1;
                    for (String instanceRequirementsRequestAcceleratorTypesListValue : instanceRequirementsRequestAcceleratorTypesList) {
                        if (instanceRequirementsRequestAcceleratorTypesListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorType." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorTypesListValue));
                        }
                        ++acceleratorTypesListIndex;
                    }
                }
                if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                    if (acceleratorCount.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                    }
                    if (acceleratorCount.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsRequestAcceleratorManufacturersList.isAutoConstruct()) {
                    int acceleratorManufacturersListIndex = 1;
                    for (Object instanceRequirementsRequestAcceleratorManufacturersListValue : instanceRequirementsRequestAcceleratorManufacturersList) {
                        if (instanceRequirementsRequestAcceleratorManufacturersListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorManufacturer." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorManufacturersListValue));
                        }
                        ++acceleratorManufacturersListIndex;
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsRequestAcceleratorNamesList.isAutoConstruct()) {
                    int acceleratorNamesListIndex = 1;
                    for (String instanceRequirementsRequestAcceleratorNamesListValue : instanceRequirementsRequestAcceleratorNamesList) {
                        if (instanceRequirementsRequestAcceleratorNamesListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorName." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorNamesListValue));
                        }
                        ++acceleratorNamesListIndex;
                    }
                }
                if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                    if (acceleratorTotalMemoryMiB.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                    }
                    if (acceleratorTotalMemoryMiB.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                    }
                }
                if ((networkBandwidthGbps = instanceRequirements.getNetworkBandwidthGbps()) != null) {
                    if (networkBandwidthGbps.getMin() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.NetworkBandwidthGbps.Min", StringUtils.fromDouble((Double)networkBandwidthGbps.getMin()));
                    }
                    if (networkBandwidthGbps.getMax() != null) {
                        request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.NetworkBandwidthGbps.Max", StringUtils.fromDouble((Double)networkBandwidthGbps.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestAllowedInstanceTypesList = (SdkInternalList)instanceRequirements.getAllowedInstanceTypes()).isEmpty() || !instanceRequirementsRequestAllowedInstanceTypesList.isAutoConstruct()) {
                    int allowedInstanceTypesListIndex = 1;
                    for (String instanceRequirementsRequestAllowedInstanceTypesListValue : instanceRequirementsRequestAllowedInstanceTypesList) {
                        if (instanceRequirementsRequestAllowedInstanceTypesListValue != null) {
                            request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.AllowedInstanceType." + allowedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAllowedInstanceTypesListValue));
                        }
                        ++allowedInstanceTypesListIndex;
                    }
                }
                if (instanceRequirements.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null) {
                    request.addParameter("InstanceRequirementsWithMetadata.InstanceRequirements.MaxSpotPriceAsPercentageOfOptimalOnDemandPrice", StringUtils.fromInteger((Integer)instanceRequirements.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice()));
                }
            }
        }
        if (getSpotPlacementScoresRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getSpotPlacementScoresRequest.getMaxResults()));
        }
        if (getSpotPlacementScoresRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getSpotPlacementScoresRequest.getNextToken()));
        }
        return request;
    }
}

