/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.Repository;

public class RepositoryJsonMarshaller {
    private static RepositoryJsonMarshaller instance;

    public void marshall(Repository repository, StructuredJsonGenerator jsonGenerator) {
        if (repository == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (repository.getRepositoryArn() != null) {
                jsonGenerator.writeFieldName("repositoryArn").writeValue(repository.getRepositoryArn());
            }
            if (repository.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(repository.getRegistryId());
            }
            if (repository.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(repository.getRepositoryName());
            }
            if (repository.getRepositoryUri() != null) {
                jsonGenerator.writeFieldName("repositoryUri").writeValue(repository.getRepositoryUri());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RepositoryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RepositoryJsonMarshaller();
        }
        return instance;
    }
}

