/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryCatalogDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryCatalogData
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<String> architectures;
    private List<String> operatingSystems;
    private String logoUrl;
    private String aboutText;
    private String usageText;
    private Boolean marketplaceCertified;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RepositoryCatalogData withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(Collection<String> architectures) {
        if (architectures == null) {
            this.architectures = null;
            return;
        }
        this.architectures = new ArrayList<String>(architectures);
    }

    public RepositoryCatalogData withArchitectures(String ... architectures) {
        if (this.architectures == null) {
            this.setArchitectures(new ArrayList<String>(architectures.length));
        }
        for (String ele : architectures) {
            this.architectures.add(ele);
        }
        return this;
    }

    public RepositoryCatalogData withArchitectures(Collection<String> architectures) {
        this.setArchitectures(architectures);
        return this;
    }

    public List<String> getOperatingSystems() {
        return this.operatingSystems;
    }

    public void setOperatingSystems(Collection<String> operatingSystems) {
        if (operatingSystems == null) {
            this.operatingSystems = null;
            return;
        }
        this.operatingSystems = new ArrayList<String>(operatingSystems);
    }

    public RepositoryCatalogData withOperatingSystems(String ... operatingSystems) {
        if (this.operatingSystems == null) {
            this.setOperatingSystems(new ArrayList<String>(operatingSystems.length));
        }
        for (String ele : operatingSystems) {
            this.operatingSystems.add(ele);
        }
        return this;
    }

    public RepositoryCatalogData withOperatingSystems(Collection<String> operatingSystems) {
        this.setOperatingSystems(operatingSystems);
        return this;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public RepositoryCatalogData withLogoUrl(String logoUrl) {
        this.setLogoUrl(logoUrl);
        return this;
    }

    public void setAboutText(String aboutText) {
        this.aboutText = aboutText;
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public RepositoryCatalogData withAboutText(String aboutText) {
        this.setAboutText(aboutText);
        return this;
    }

    public void setUsageText(String usageText) {
        this.usageText = usageText;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public RepositoryCatalogData withUsageText(String usageText) {
        this.setUsageText(usageText);
        return this;
    }

    public void setMarketplaceCertified(Boolean marketplaceCertified) {
        this.marketplaceCertified = marketplaceCertified;
    }

    public Boolean getMarketplaceCertified() {
        return this.marketplaceCertified;
    }

    public RepositoryCatalogData withMarketplaceCertified(Boolean marketplaceCertified) {
        this.setMarketplaceCertified(marketplaceCertified);
        return this;
    }

    public Boolean isMarketplaceCertified() {
        return this.marketplaceCertified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getArchitectures() != null) {
            sb.append("Architectures: ").append(this.getArchitectures()).append(",");
        }
        if (this.getOperatingSystems() != null) {
            sb.append("OperatingSystems: ").append(this.getOperatingSystems()).append(",");
        }
        if (this.getLogoUrl() != null) {
            sb.append("LogoUrl: ").append(this.getLogoUrl()).append(",");
        }
        if (this.getAboutText() != null) {
            sb.append("AboutText: ").append(this.getAboutText()).append(",");
        }
        if (this.getUsageText() != null) {
            sb.append("UsageText: ").append(this.getUsageText()).append(",");
        }
        if (this.getMarketplaceCertified() != null) {
            sb.append("MarketplaceCertified: ").append(this.getMarketplaceCertified());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogData)) {
            return false;
        }
        RepositoryCatalogData other = (RepositoryCatalogData)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getArchitectures() == null ^ this.getArchitectures() == null) {
            return false;
        }
        if (other.getArchitectures() != null && !other.getArchitectures().equals(this.getArchitectures())) {
            return false;
        }
        if (other.getOperatingSystems() == null ^ this.getOperatingSystems() == null) {
            return false;
        }
        if (other.getOperatingSystems() != null && !other.getOperatingSystems().equals(this.getOperatingSystems())) {
            return false;
        }
        if (other.getLogoUrl() == null ^ this.getLogoUrl() == null) {
            return false;
        }
        if (other.getLogoUrl() != null && !other.getLogoUrl().equals(this.getLogoUrl())) {
            return false;
        }
        if (other.getAboutText() == null ^ this.getAboutText() == null) {
            return false;
        }
        if (other.getAboutText() != null && !other.getAboutText().equals(this.getAboutText())) {
            return false;
        }
        if (other.getUsageText() == null ^ this.getUsageText() == null) {
            return false;
        }
        if (other.getUsageText() != null && !other.getUsageText().equals(this.getUsageText())) {
            return false;
        }
        if (other.getMarketplaceCertified() == null ^ this.getMarketplaceCertified() == null) {
            return false;
        }
        return other.getMarketplaceCertified() == null || other.getMarketplaceCertified().equals(this.getMarketplaceCertified());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArchitectures() == null ? 0 : this.getArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystems() == null ? 0 : this.getOperatingSystems().hashCode());
        hashCode = 31 * hashCode + (this.getLogoUrl() == null ? 0 : this.getLogoUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAboutText() == null ? 0 : this.getAboutText().hashCode());
        hashCode = 31 * hashCode + (this.getUsageText() == null ? 0 : this.getUsageText().hashCode());
        hashCode = 31 * hashCode + (this.getMarketplaceCertified() == null ? 0 : this.getMarketplaceCertified().hashCode());
        return hashCode;
    }

    public RepositoryCatalogData clone() {
        try {
            return (RepositoryCatalogData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryCatalogDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

