/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateMountTargetRequestMarshaller
implements Marshaller<Request<CreateMountTargetRequest>, CreateMountTargetRequest> {
    public Request<CreateMountTargetRequest> marshall(CreateMountTargetRequest createMountTargetRequest) {
        if (createMountTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMountTargetRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList securityGroupsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createMountTargetRequest.getFileSystemId() != null) {
                jsonWriter.key("FileSystemId").value((Object)createMountTargetRequest.getFileSystemId());
            }
            if (createMountTargetRequest.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)createMountTargetRequest.getSubnetId());
            }
            if (createMountTargetRequest.getIpAddress() != null) {
                jsonWriter.key("IpAddress").value((Object)createMountTargetRequest.getIpAddress());
            }
            if (!(securityGroupsList = (SdkInternalList)createMountTargetRequest.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
                jsonWriter.key("SecurityGroups");
                jsonWriter.array();
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue == null) continue;
                    jsonWriter.value((Object)securityGroupsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

