/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeFileSystemsRequestMarshaller
implements Marshaller<Request<DescribeFileSystemsRequest>, DescribeFileSystemsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeFileSystemsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeFileSystemsRequest> marshall(DescribeFileSystemsRequest describeFileSystemsRequest) {
        if (describeFileSystemsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFileSystemsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/file-systems";
        request.setResourcePath(uriResourcePath);
        if (describeFileSystemsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)describeFileSystemsRequest.getMaxItems()));
        }
        if (describeFileSystemsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeFileSystemsRequest.getMarker()));
        }
        if (describeFileSystemsRequest.getCreationToken() != null) {
            request.addParameter("CreationToken", StringUtils.fromString((String)describeFileSystemsRequest.getCreationToken()));
        }
        if (describeFileSystemsRequest.getFileSystemId() != null) {
            request.addParameter("FileSystemId", StringUtils.fromString((String)describeFileSystemsRequest.getFileSystemId()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

