/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.Action;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").build();
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final ActionMarshaller instance = new ActionMarshaller();

    public static ActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        if (action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)action.getAttributeName(), ATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall((Object)action.getOperation(), OPERATION_BINDING);
            protocolMarshaller.marshall((Object)action.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

