/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.EventType;
import com.amazonaws.services.fsx.model.transform.AutoImportPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoImportPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> events;

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<String>(events);
    }

    public AutoImportPolicy withEvents(String ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<String>(events.length));
        }
        for (String ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public AutoImportPolicy withEvents(Collection<String> events) {
        this.setEvents(events);
        return this;
    }

    public AutoImportPolicy withEvents(EventType ... events) {
        ArrayList<String> eventsCopy = new ArrayList<String>(events.length);
        for (EventType value : events) {
            eventsCopy.add(value.toString());
        }
        if (this.getEvents() == null) {
            this.setEvents(eventsCopy);
        } else {
            this.getEvents().addAll(eventsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoImportPolicy)) {
            return false;
        }
        AutoImportPolicy other = (AutoImportPolicy)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public AutoImportPolicy clone() {
        try {
            return (AutoImportPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoImportPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

