/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreatePlayerSessionsRequestMarshaller
implements Marshaller<Request<CreatePlayerSessionsRequest>, CreatePlayerSessionsRequest> {
    public Request<CreatePlayerSessionsRequest> marshall(CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        if (createPlayerSessionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlayerSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreatePlayerSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> playerIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createPlayerSessionsRequest.getGameSessionId() != null) {
                jsonWriter.key("GameSessionId").value((Object)createPlayerSessionsRequest.getGameSessionId());
            }
            if ((playerIdsList = createPlayerSessionsRequest.getPlayerIds()) != null) {
                jsonWriter.key("PlayerIds");
                jsonWriter.array();
                for (String playerIdsListValue : playerIdsList) {
                    if (playerIdsListValue == null) continue;
                    jsonWriter.value((Object)playerIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

