/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.UpdateGameSessionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateGameSessionRequestMarshaller
implements Marshaller<Request<UpdateGameSessionRequest>, UpdateGameSessionRequest> {
    public Request<UpdateGameSessionRequest> marshall(UpdateGameSessionRequest updateGameSessionRequest) {
        if (updateGameSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateGameSessionRequest.getGameSessionId() != null) {
                jsonWriter.key("GameSessionId").value((Object)updateGameSessionRequest.getGameSessionId());
            }
            if (updateGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonWriter.key("MaximumPlayerSessionCount").value((Object)updateGameSessionRequest.getMaximumPlayerSessionCount());
            }
            if (updateGameSessionRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)updateGameSessionRequest.getName());
            }
            if (updateGameSessionRequest.getPlayerSessionCreationPolicy() != null) {
                jsonWriter.key("PlayerSessionCreationPolicy").value((Object)updateGameSessionRequest.getPlayerSessionCreationPolicy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

