/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListFleetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListFleetsRequestMarshaller
implements Marshaller<Request<ListFleetsRequest>, ListFleetsRequest> {
    public Request<ListFleetsRequest> marshall(ListFleetsRequest listFleetsRequest) {
        if (listFleetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listFleetsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListFleets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listFleetsRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(listFleetsRequest.getBuildId());
            }
            if (listFleetsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listFleetsRequest.getLimit().intValue());
            }
            if (listFleetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listFleetsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

