/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.Build;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class BuildJsonMarshaller {
    private static BuildJsonMarshaller instance;

    public void marshall(Build build, StructuredJsonGenerator jsonGenerator) {
        if (build == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (build.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(build.getBuildId());
            }
            if (build.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(build.getName());
            }
            if (build.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(build.getVersion());
            }
            if (build.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(build.getStatus());
            }
            if (build.getSizeOnDisk() != null) {
                jsonGenerator.writeFieldName("SizeOnDisk").writeValue(build.getSizeOnDisk().longValue());
            }
            if (build.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(build.getCreationTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BuildJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BuildJsonMarshaller();
        }
        return instance;
    }
}

