/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.GameProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGameSessionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fleetId;
    private String aliasId;
    private Integer maximumPlayerSessionCount;
    private String name;
    private List<GameProperty> gameProperties;
    private String creatorId;
    private String gameSessionId;
    private String idempotencyToken;

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public CreateGameSessionRequest withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public String getAliasId() {
        return this.aliasId;
    }

    public CreateGameSessionRequest withAliasId(String aliasId) {
        this.setAliasId(aliasId);
        return this;
    }

    public void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.maximumPlayerSessionCount = maximumPlayerSessionCount;
    }

    public Integer getMaximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public CreateGameSessionRequest withMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.setMaximumPlayerSessionCount(maximumPlayerSessionCount);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateGameSessionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<GameProperty> getGameProperties() {
        return this.gameProperties;
    }

    public void setGameProperties(Collection<GameProperty> gameProperties) {
        if (gameProperties == null) {
            this.gameProperties = null;
            return;
        }
        this.gameProperties = new ArrayList<GameProperty>(gameProperties);
    }

    public CreateGameSessionRequest withGameProperties(GameProperty ... gameProperties) {
        if (this.gameProperties == null) {
            this.setGameProperties(new ArrayList<GameProperty>(gameProperties.length));
        }
        for (GameProperty ele : gameProperties) {
            this.gameProperties.add(ele);
        }
        return this;
    }

    public CreateGameSessionRequest withGameProperties(Collection<GameProperty> gameProperties) {
        this.setGameProperties(gameProperties);
        return this;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public CreateGameSessionRequest withCreatorId(String creatorId) {
        this.setCreatorId(creatorId);
        return this;
    }

    public void setGameSessionId(String gameSessionId) {
        this.gameSessionId = gameSessionId;
    }

    public String getGameSessionId() {
        return this.gameSessionId;
    }

    public CreateGameSessionRequest withGameSessionId(String gameSessionId) {
        this.setGameSessionId(gameSessionId);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateGameSessionRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId()).append(",");
        }
        if (this.getAliasId() != null) {
            sb.append("AliasId: ").append(this.getAliasId()).append(",");
        }
        if (this.getMaximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.getMaximumPlayerSessionCount()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getGameProperties() != null) {
            sb.append("GameProperties: ").append(this.getGameProperties()).append(",");
        }
        if (this.getCreatorId() != null) {
            sb.append("CreatorId: ").append(this.getCreatorId()).append(",");
        }
        if (this.getGameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.getGameSessionId()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest)obj;
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        if (other.getFleetId() != null && !other.getFleetId().equals(this.getFleetId())) {
            return false;
        }
        if (other.getAliasId() == null ^ this.getAliasId() == null) {
            return false;
        }
        if (other.getAliasId() != null && !other.getAliasId().equals(this.getAliasId())) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() == null ^ this.getMaximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() != null && !other.getMaximumPlayerSessionCount().equals(this.getMaximumPlayerSessionCount())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getGameProperties() == null ^ this.getGameProperties() == null) {
            return false;
        }
        if (other.getGameProperties() != null && !other.getGameProperties().equals(this.getGameProperties())) {
            return false;
        }
        if (other.getCreatorId() == null ^ this.getCreatorId() == null) {
            return false;
        }
        if (other.getCreatorId() != null && !other.getCreatorId().equals(this.getCreatorId())) {
            return false;
        }
        if (other.getGameSessionId() == null ^ this.getGameSessionId() == null) {
            return false;
        }
        if (other.getGameSessionId() != null && !other.getGameSessionId().equals(this.getGameSessionId())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        hashCode = 31 * hashCode + (this.getAliasId() == null ? 0 : this.getAliasId().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumPlayerSessionCount() == null ? 0 : this.getMaximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getGameProperties() == null ? 0 : this.getGameProperties().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorId() == null ? 0 : this.getCreatorId().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionId() == null ? 0 : this.getGameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public CreateGameSessionRequest clone() {
        return (CreateGameSessionRequest)super.clone();
    }
}

