/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreatePlayerSessionsRequestMarshaller
implements Marshaller<Request<CreatePlayerSessionsRequest>, CreatePlayerSessionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreatePlayerSessionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreatePlayerSessionsRequest> marshall(CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        if (createPlayerSessionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlayerSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreatePlayerSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> playerIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPlayerSessionsRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(createPlayerSessionsRequest.getGameSessionId());
            }
            if ((playerIdsList = createPlayerSessionsRequest.getPlayerIds()) != null) {
                jsonGenerator.writeFieldName("PlayerIds");
                jsonGenerator.writeStartArray();
                for (String playerIdsListValue : playerIdsList) {
                    if (playerIdsListValue == null) continue;
                    jsonGenerator.writeValue(playerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

