/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.FleetCapacity;
import com.amazonaws.services.gamelift.model.transform.EC2InstanceCountsJsonMarshaller;

public class FleetCapacityJsonMarshaller {
    private static FleetCapacityJsonMarshaller instance;

    public void marshall(FleetCapacity fleetCapacity, StructuredJsonGenerator jsonGenerator) {
        if (fleetCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (fleetCapacity.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(fleetCapacity.getFleetId());
            }
            if (fleetCapacity.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(fleetCapacity.getInstanceType());
            }
            if (fleetCapacity.getInstanceCounts() != null) {
                jsonGenerator.writeFieldName("InstanceCounts");
                EC2InstanceCountsJsonMarshaller.getInstance().marshall(fleetCapacity.getInstanceCounts(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FleetCapacityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FleetCapacityJsonMarshaller();
        }
        return instance;
    }
}

