/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamesparks;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.gamesparks.AWSGameSparksAsync;
import com.amazonaws.services.gamesparks.AWSGameSparksAsyncClientBuilder;
import com.amazonaws.services.gamesparks.AWSGameSparksClient;
import com.amazonaws.services.gamesparks.model.CreateGameRequest;
import com.amazonaws.services.gamesparks.model.CreateGameResult;
import com.amazonaws.services.gamesparks.model.CreateSnapshotRequest;
import com.amazonaws.services.gamesparks.model.CreateSnapshotResult;
import com.amazonaws.services.gamesparks.model.CreateStageRequest;
import com.amazonaws.services.gamesparks.model.CreateStageResult;
import com.amazonaws.services.gamesparks.model.DeleteGameRequest;
import com.amazonaws.services.gamesparks.model.DeleteGameResult;
import com.amazonaws.services.gamesparks.model.DeleteStageRequest;
import com.amazonaws.services.gamesparks.model.DeleteStageResult;
import com.amazonaws.services.gamesparks.model.DisconnectPlayerRequest;
import com.amazonaws.services.gamesparks.model.DisconnectPlayerResult;
import com.amazonaws.services.gamesparks.model.ExportSnapshotRequest;
import com.amazonaws.services.gamesparks.model.ExportSnapshotResult;
import com.amazonaws.services.gamesparks.model.GetExtensionRequest;
import com.amazonaws.services.gamesparks.model.GetExtensionResult;
import com.amazonaws.services.gamesparks.model.GetExtensionVersionRequest;
import com.amazonaws.services.gamesparks.model.GetExtensionVersionResult;
import com.amazonaws.services.gamesparks.model.GetGameConfigurationRequest;
import com.amazonaws.services.gamesparks.model.GetGameConfigurationResult;
import com.amazonaws.services.gamesparks.model.GetGameRequest;
import com.amazonaws.services.gamesparks.model.GetGameResult;
import com.amazonaws.services.gamesparks.model.GetGeneratedCodeJobRequest;
import com.amazonaws.services.gamesparks.model.GetGeneratedCodeJobResult;
import com.amazonaws.services.gamesparks.model.GetPlayerConnectionStatusRequest;
import com.amazonaws.services.gamesparks.model.GetPlayerConnectionStatusResult;
import com.amazonaws.services.gamesparks.model.GetSnapshotRequest;
import com.amazonaws.services.gamesparks.model.GetSnapshotResult;
import com.amazonaws.services.gamesparks.model.GetStageDeploymentRequest;
import com.amazonaws.services.gamesparks.model.GetStageDeploymentResult;
import com.amazonaws.services.gamesparks.model.GetStageRequest;
import com.amazonaws.services.gamesparks.model.GetStageResult;
import com.amazonaws.services.gamesparks.model.ImportGameConfigurationRequest;
import com.amazonaws.services.gamesparks.model.ImportGameConfigurationResult;
import com.amazonaws.services.gamesparks.model.ListExtensionVersionsRequest;
import com.amazonaws.services.gamesparks.model.ListExtensionVersionsResult;
import com.amazonaws.services.gamesparks.model.ListExtensionsRequest;
import com.amazonaws.services.gamesparks.model.ListExtensionsResult;
import com.amazonaws.services.gamesparks.model.ListGamesRequest;
import com.amazonaws.services.gamesparks.model.ListGamesResult;
import com.amazonaws.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import com.amazonaws.services.gamesparks.model.ListGeneratedCodeJobsResult;
import com.amazonaws.services.gamesparks.model.ListSnapshotsRequest;
import com.amazonaws.services.gamesparks.model.ListSnapshotsResult;
import com.amazonaws.services.gamesparks.model.ListStageDeploymentsRequest;
import com.amazonaws.services.gamesparks.model.ListStageDeploymentsResult;
import com.amazonaws.services.gamesparks.model.ListStagesRequest;
import com.amazonaws.services.gamesparks.model.ListStagesResult;
import com.amazonaws.services.gamesparks.model.ListTagsForResourceRequest;
import com.amazonaws.services.gamesparks.model.ListTagsForResourceResult;
import com.amazonaws.services.gamesparks.model.StartGeneratedCodeJobRequest;
import com.amazonaws.services.gamesparks.model.StartGeneratedCodeJobResult;
import com.amazonaws.services.gamesparks.model.StartStageDeploymentRequest;
import com.amazonaws.services.gamesparks.model.StartStageDeploymentResult;
import com.amazonaws.services.gamesparks.model.TagResourceRequest;
import com.amazonaws.services.gamesparks.model.TagResourceResult;
import com.amazonaws.services.gamesparks.model.UntagResourceRequest;
import com.amazonaws.services.gamesparks.model.UntagResourceResult;
import com.amazonaws.services.gamesparks.model.UpdateGameConfigurationRequest;
import com.amazonaws.services.gamesparks.model.UpdateGameConfigurationResult;
import com.amazonaws.services.gamesparks.model.UpdateGameRequest;
import com.amazonaws.services.gamesparks.model.UpdateGameResult;
import com.amazonaws.services.gamesparks.model.UpdateSnapshotRequest;
import com.amazonaws.services.gamesparks.model.UpdateSnapshotResult;
import com.amazonaws.services.gamesparks.model.UpdateStageRequest;
import com.amazonaws.services.gamesparks.model.UpdateStageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSGameSparksAsyncClient
extends AWSGameSparksClient
implements AWSGameSparksAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSGameSparksAsyncClientBuilder asyncBuilder() {
        return AWSGameSparksAsyncClientBuilder.standard();
    }

    AWSGameSparksAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSGameSparksAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateGameResult> createGameAsync(CreateGameRequest request) {
        return this.createGameAsync(request, null);
    }

    @Override
    public Future<CreateGameResult> createGameAsync(CreateGameRequest request, final AsyncHandler<CreateGameRequest, CreateGameResult> asyncHandler) {
        final CreateGameRequest finalRequest = (CreateGameRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGameResult>(){

            @Override
            public CreateGameResult call() throws Exception {
                CreateGameResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeCreateGame(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        final CreateSnapshotRequest finalRequest = (CreateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStageResult> createStageAsync(CreateStageRequest request) {
        return this.createStageAsync(request, null);
    }

    @Override
    public Future<CreateStageResult> createStageAsync(CreateStageRequest request, final AsyncHandler<CreateStageRequest, CreateStageResult> asyncHandler) {
        final CreateStageRequest finalRequest = (CreateStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStageResult>(){

            @Override
            public CreateStageResult call() throws Exception {
                CreateStageResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeCreateStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGameResult> deleteGameAsync(DeleteGameRequest request) {
        return this.deleteGameAsync(request, null);
    }

    @Override
    public Future<DeleteGameResult> deleteGameAsync(DeleteGameRequest request, final AsyncHandler<DeleteGameRequest, DeleteGameResult> asyncHandler) {
        final DeleteGameRequest finalRequest = (DeleteGameRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGameResult>(){

            @Override
            public DeleteGameResult call() throws Exception {
                DeleteGameResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeDeleteGame(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request) {
        return this.deleteStageAsync(request, null);
    }

    @Override
    public Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request, final AsyncHandler<DeleteStageRequest, DeleteStageResult> asyncHandler) {
        final DeleteStageRequest finalRequest = (DeleteStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStageResult>(){

            @Override
            public DeleteStageResult call() throws Exception {
                DeleteStageResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeDeleteStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisconnectPlayerResult> disconnectPlayerAsync(DisconnectPlayerRequest request) {
        return this.disconnectPlayerAsync(request, null);
    }

    @Override
    public Future<DisconnectPlayerResult> disconnectPlayerAsync(DisconnectPlayerRequest request, final AsyncHandler<DisconnectPlayerRequest, DisconnectPlayerResult> asyncHandler) {
        final DisconnectPlayerRequest finalRequest = (DisconnectPlayerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisconnectPlayerResult>(){

            @Override
            public DisconnectPlayerResult call() throws Exception {
                DisconnectPlayerResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeDisconnectPlayer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportSnapshotResult> exportSnapshotAsync(ExportSnapshotRequest request) {
        return this.exportSnapshotAsync(request, null);
    }

    @Override
    public Future<ExportSnapshotResult> exportSnapshotAsync(ExportSnapshotRequest request, final AsyncHandler<ExportSnapshotRequest, ExportSnapshotResult> asyncHandler) {
        final ExportSnapshotRequest finalRequest = (ExportSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportSnapshotResult>(){

            @Override
            public ExportSnapshotResult call() throws Exception {
                ExportSnapshotResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeExportSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExtensionResult> getExtensionAsync(GetExtensionRequest request) {
        return this.getExtensionAsync(request, null);
    }

    @Override
    public Future<GetExtensionResult> getExtensionAsync(GetExtensionRequest request, final AsyncHandler<GetExtensionRequest, GetExtensionResult> asyncHandler) {
        final GetExtensionRequest finalRequest = (GetExtensionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExtensionResult>(){

            @Override
            public GetExtensionResult call() throws Exception {
                GetExtensionResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetExtension(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExtensionVersionResult> getExtensionVersionAsync(GetExtensionVersionRequest request) {
        return this.getExtensionVersionAsync(request, null);
    }

    @Override
    public Future<GetExtensionVersionResult> getExtensionVersionAsync(GetExtensionVersionRequest request, final AsyncHandler<GetExtensionVersionRequest, GetExtensionVersionResult> asyncHandler) {
        final GetExtensionVersionRequest finalRequest = (GetExtensionVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExtensionVersionResult>(){

            @Override
            public GetExtensionVersionResult call() throws Exception {
                GetExtensionVersionResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetExtensionVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGameResult> getGameAsync(GetGameRequest request) {
        return this.getGameAsync(request, null);
    }

    @Override
    public Future<GetGameResult> getGameAsync(GetGameRequest request, final AsyncHandler<GetGameRequest, GetGameResult> asyncHandler) {
        final GetGameRequest finalRequest = (GetGameRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGameResult>(){

            @Override
            public GetGameResult call() throws Exception {
                GetGameResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetGame(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGameConfigurationResult> getGameConfigurationAsync(GetGameConfigurationRequest request) {
        return this.getGameConfigurationAsync(request, null);
    }

    @Override
    public Future<GetGameConfigurationResult> getGameConfigurationAsync(GetGameConfigurationRequest request, final AsyncHandler<GetGameConfigurationRequest, GetGameConfigurationResult> asyncHandler) {
        final GetGameConfigurationRequest finalRequest = (GetGameConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGameConfigurationResult>(){

            @Override
            public GetGameConfigurationResult call() throws Exception {
                GetGameConfigurationResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetGameConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGeneratedCodeJobResult> getGeneratedCodeJobAsync(GetGeneratedCodeJobRequest request) {
        return this.getGeneratedCodeJobAsync(request, null);
    }

    @Override
    public Future<GetGeneratedCodeJobResult> getGeneratedCodeJobAsync(GetGeneratedCodeJobRequest request, final AsyncHandler<GetGeneratedCodeJobRequest, GetGeneratedCodeJobResult> asyncHandler) {
        final GetGeneratedCodeJobRequest finalRequest = (GetGeneratedCodeJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGeneratedCodeJobResult>(){

            @Override
            public GetGeneratedCodeJobResult call() throws Exception {
                GetGeneratedCodeJobResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetGeneratedCodeJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlayerConnectionStatusResult> getPlayerConnectionStatusAsync(GetPlayerConnectionStatusRequest request) {
        return this.getPlayerConnectionStatusAsync(request, null);
    }

    @Override
    public Future<GetPlayerConnectionStatusResult> getPlayerConnectionStatusAsync(GetPlayerConnectionStatusRequest request, final AsyncHandler<GetPlayerConnectionStatusRequest, GetPlayerConnectionStatusResult> asyncHandler) {
        final GetPlayerConnectionStatusRequest finalRequest = (GetPlayerConnectionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPlayerConnectionStatusResult>(){

            @Override
            public GetPlayerConnectionStatusResult call() throws Exception {
                GetPlayerConnectionStatusResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetPlayerConnectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request) {
        return this.getSnapshotAsync(request, null);
    }

    @Override
    public Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request, final AsyncHandler<GetSnapshotRequest, GetSnapshotResult> asyncHandler) {
        final GetSnapshotRequest finalRequest = (GetSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSnapshotResult>(){

            @Override
            public GetSnapshotResult call() throws Exception {
                GetSnapshotResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStageResult> getStageAsync(GetStageRequest request) {
        return this.getStageAsync(request, null);
    }

    @Override
    public Future<GetStageResult> getStageAsync(GetStageRequest request, final AsyncHandler<GetStageRequest, GetStageResult> asyncHandler) {
        final GetStageRequest finalRequest = (GetStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStageResult>(){

            @Override
            public GetStageResult call() throws Exception {
                GetStageResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStageDeploymentResult> getStageDeploymentAsync(GetStageDeploymentRequest request) {
        return this.getStageDeploymentAsync(request, null);
    }

    @Override
    public Future<GetStageDeploymentResult> getStageDeploymentAsync(GetStageDeploymentRequest request, final AsyncHandler<GetStageDeploymentRequest, GetStageDeploymentResult> asyncHandler) {
        final GetStageDeploymentRequest finalRequest = (GetStageDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStageDeploymentResult>(){

            @Override
            public GetStageDeploymentResult call() throws Exception {
                GetStageDeploymentResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeGetStageDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportGameConfigurationResult> importGameConfigurationAsync(ImportGameConfigurationRequest request) {
        return this.importGameConfigurationAsync(request, null);
    }

    @Override
    public Future<ImportGameConfigurationResult> importGameConfigurationAsync(ImportGameConfigurationRequest request, final AsyncHandler<ImportGameConfigurationRequest, ImportGameConfigurationResult> asyncHandler) {
        final ImportGameConfigurationRequest finalRequest = (ImportGameConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportGameConfigurationResult>(){

            @Override
            public ImportGameConfigurationResult call() throws Exception {
                ImportGameConfigurationResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeImportGameConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExtensionVersionsResult> listExtensionVersionsAsync(ListExtensionVersionsRequest request) {
        return this.listExtensionVersionsAsync(request, null);
    }

    @Override
    public Future<ListExtensionVersionsResult> listExtensionVersionsAsync(ListExtensionVersionsRequest request, final AsyncHandler<ListExtensionVersionsRequest, ListExtensionVersionsResult> asyncHandler) {
        final ListExtensionVersionsRequest finalRequest = (ListExtensionVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExtensionVersionsResult>(){

            @Override
            public ListExtensionVersionsResult call() throws Exception {
                ListExtensionVersionsResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListExtensionVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExtensionsResult> listExtensionsAsync(ListExtensionsRequest request) {
        return this.listExtensionsAsync(request, null);
    }

    @Override
    public Future<ListExtensionsResult> listExtensionsAsync(ListExtensionsRequest request, final AsyncHandler<ListExtensionsRequest, ListExtensionsResult> asyncHandler) {
        final ListExtensionsRequest finalRequest = (ListExtensionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExtensionsResult>(){

            @Override
            public ListExtensionsResult call() throws Exception {
                ListExtensionsResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListExtensions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGamesResult> listGamesAsync(ListGamesRequest request) {
        return this.listGamesAsync(request, null);
    }

    @Override
    public Future<ListGamesResult> listGamesAsync(ListGamesRequest request, final AsyncHandler<ListGamesRequest, ListGamesResult> asyncHandler) {
        final ListGamesRequest finalRequest = (ListGamesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGamesResult>(){

            @Override
            public ListGamesResult call() throws Exception {
                ListGamesResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListGames(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGeneratedCodeJobsResult> listGeneratedCodeJobsAsync(ListGeneratedCodeJobsRequest request) {
        return this.listGeneratedCodeJobsAsync(request, null);
    }

    @Override
    public Future<ListGeneratedCodeJobsResult> listGeneratedCodeJobsAsync(ListGeneratedCodeJobsRequest request, final AsyncHandler<ListGeneratedCodeJobsRequest, ListGeneratedCodeJobsResult> asyncHandler) {
        final ListGeneratedCodeJobsRequest finalRequest = (ListGeneratedCodeJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGeneratedCodeJobsResult>(){

            @Override
            public ListGeneratedCodeJobsResult call() throws Exception {
                ListGeneratedCodeJobsResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListGeneratedCodeJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request) {
        return this.listSnapshotsAsync(request, null);
    }

    @Override
    public Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request, final AsyncHandler<ListSnapshotsRequest, ListSnapshotsResult> asyncHandler) {
        final ListSnapshotsRequest finalRequest = (ListSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSnapshotsResult>(){

            @Override
            public ListSnapshotsResult call() throws Exception {
                ListSnapshotsResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStageDeploymentsResult> listStageDeploymentsAsync(ListStageDeploymentsRequest request) {
        return this.listStageDeploymentsAsync(request, null);
    }

    @Override
    public Future<ListStageDeploymentsResult> listStageDeploymentsAsync(ListStageDeploymentsRequest request, final AsyncHandler<ListStageDeploymentsRequest, ListStageDeploymentsResult> asyncHandler) {
        final ListStageDeploymentsRequest finalRequest = (ListStageDeploymentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStageDeploymentsResult>(){

            @Override
            public ListStageDeploymentsResult call() throws Exception {
                ListStageDeploymentsResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListStageDeployments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStagesResult> listStagesAsync(ListStagesRequest request) {
        return this.listStagesAsync(request, null);
    }

    @Override
    public Future<ListStagesResult> listStagesAsync(ListStagesRequest request, final AsyncHandler<ListStagesRequest, ListStagesResult> asyncHandler) {
        final ListStagesRequest finalRequest = (ListStagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStagesResult>(){

            @Override
            public ListStagesResult call() throws Exception {
                ListStagesResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListStages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartGeneratedCodeJobResult> startGeneratedCodeJobAsync(StartGeneratedCodeJobRequest request) {
        return this.startGeneratedCodeJobAsync(request, null);
    }

    @Override
    public Future<StartGeneratedCodeJobResult> startGeneratedCodeJobAsync(StartGeneratedCodeJobRequest request, final AsyncHandler<StartGeneratedCodeJobRequest, StartGeneratedCodeJobResult> asyncHandler) {
        final StartGeneratedCodeJobRequest finalRequest = (StartGeneratedCodeJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartGeneratedCodeJobResult>(){

            @Override
            public StartGeneratedCodeJobResult call() throws Exception {
                StartGeneratedCodeJobResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeStartGeneratedCodeJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartStageDeploymentResult> startStageDeploymentAsync(StartStageDeploymentRequest request) {
        return this.startStageDeploymentAsync(request, null);
    }

    @Override
    public Future<StartStageDeploymentResult> startStageDeploymentAsync(StartStageDeploymentRequest request, final AsyncHandler<StartStageDeploymentRequest, StartStageDeploymentResult> asyncHandler) {
        final StartStageDeploymentRequest finalRequest = (StartStageDeploymentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartStageDeploymentResult>(){

            @Override
            public StartStageDeploymentResult call() throws Exception {
                StartStageDeploymentResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeStartStageDeployment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGameResult> updateGameAsync(UpdateGameRequest request) {
        return this.updateGameAsync(request, null);
    }

    @Override
    public Future<UpdateGameResult> updateGameAsync(UpdateGameRequest request, final AsyncHandler<UpdateGameRequest, UpdateGameResult> asyncHandler) {
        final UpdateGameRequest finalRequest = (UpdateGameRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGameResult>(){

            @Override
            public UpdateGameResult call() throws Exception {
                UpdateGameResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeUpdateGame(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGameConfigurationResult> updateGameConfigurationAsync(UpdateGameConfigurationRequest request) {
        return this.updateGameConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateGameConfigurationResult> updateGameConfigurationAsync(UpdateGameConfigurationRequest request, final AsyncHandler<UpdateGameConfigurationRequest, UpdateGameConfigurationResult> asyncHandler) {
        final UpdateGameConfigurationRequest finalRequest = (UpdateGameConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGameConfigurationResult>(){

            @Override
            public UpdateGameConfigurationResult call() throws Exception {
                UpdateGameConfigurationResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeUpdateGameConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request) {
        return this.updateSnapshotAsync(request, null);
    }

    @Override
    public Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request, final AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResult> asyncHandler) {
        final UpdateSnapshotRequest finalRequest = (UpdateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSnapshotResult>(){

            @Override
            public UpdateSnapshotResult call() throws Exception {
                UpdateSnapshotResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeUpdateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request) {
        return this.updateStageAsync(request, null);
    }

    @Override
    public Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request, final AsyncHandler<UpdateStageRequest, UpdateStageResult> asyncHandler) {
        final UpdateStageRequest finalRequest = (UpdateStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStageResult>(){

            @Override
            public UpdateStageResult call() throws Exception {
                UpdateStageResult result = null;
                try {
                    result = AWSGameSparksAsyncClient.this.executeUpdateStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

