/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.S3Action;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class S3ActionJsonMarshaller {
    private static S3ActionJsonMarshaller instance;

    public void marshall(S3Action s3Action, StructuredJsonGenerator jsonGenerator) {
        if (s3Action == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3Action.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(s3Action.getRoleArn());
            }
            if (s3Action.getBucketName() != null) {
                jsonGenerator.writeFieldName("bucketName").writeValue(s3Action.getBucketName());
            }
            if (s3Action.getKey() != null) {
                jsonGenerator.writeFieldName("key").writeValue(s3Action.getKey());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3ActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3ActionJsonMarshaller();
        }
        return instance;
    }
}

